import { TasaService } from './tasa.service';
import { ConsultaGeneralDto } from './dto/consulta-tasa.dto';
import { HealthCheckResult, ResultadoConsulta } from './interfaces/tasa.interface';
import { DatabaseService } from './database/database.service';
export declare class TasaController {
    private readonly tasaService;
    private readonly databaseService;
    private readonly logger;
    constructor(tasaService: TasaService, databaseService: DatabaseService);
    healthCheck(): Promise<HealthCheckResult>;
    getEmpresasDisponibles(): string[];
    getBasesDatosDisponibles(): string[];
    getConnectionStats(): {
        totalConnectionsCreated: number;
        currentlyActiveConnections: number;
        activeConnections: {
            database: string;
            status: string;
        }[];
    };
    consultarRegistros(dto: ConsultaGeneralDto): Promise<ResultadoConsulta>;
    ruta1_ultimoRegistroGeneral(): Promise<ResultadoConsulta>;
    ruta3_ultimoRegistroSistema(sistema: string): Promise<ResultadoConsulta>;
    ruta4_registrosSistema(sistema: string, limit: string): Promise<ResultadoConsulta>;
    ruta5_ultimoRegistroBaseDatos(embarcacion: string): Promise<ResultadoConsulta>;
    ruta6_registrosBaseDatos(embarcacion: string, limit: string): Promise<ResultadoConsulta>;
    ruta7_consultaCompletaBaseDatos(embarcacion: string, fechaInicio: string, fechaFin: string, sistema: string): Promise<ResultadoConsulta>;
    ruta8_consultaPorFechas(fechaInicio: string, fechaFin: string): Promise<ResultadoConsulta>;
    ruta9_consultaPorFechasSistema(fechaInicio: string, fechaFin: string, sistema: string): Promise<ResultadoConsulta>;
    ruta2_registrosGenerales(limit: string): Promise<ResultadoConsulta>;
    private isValidDate;
    private validateDateRange;
}
