"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var ResultAggregatorService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResultAggregatorService = void 0;
const common_1 = require("@nestjs/common");
const sistema_config_service_1 = require("./sistema-config.service");
let ResultAggregatorService = ResultAggregatorService_1 = class ResultAggregatorService {
    sistemaConfigService;
    logger = new common_1.Logger(ResultAggregatorService_1.name);
    prioridadReportes = {
        slave1: 1,
        slave2: 2,
        slave3: 3,
        slave4: 4,
        slave5: 5,
        slave6: 6,
        bomba: 7,
        bnwas: 8,
        pesca: 9,
        comp1: 10,
        comp2: 11,
        planta: 12,
        restfull: 13,
    };
    constructor(sistemaConfigService) {
        this.sistemaConfigService = sistemaConfigService;
    }
    agruparPorEmbarcacion(resultados) {
        const agrupado = {};
        for (const { registros } of resultados) {
            for (const registro of registros) {
                const embarcacion = registro.tabla || registro.Tabla;
                if (embarcacion) {
                    if (!agrupado[embarcacion]) {
                        agrupado[embarcacion] = [];
                    }
                    agrupado[embarcacion].push(registro);
                }
            }
        }
        for (const embarcacion in agrupado) {
            agrupado[embarcacion] = this.ordenarRegistrosPorReporteYFecha(agrupado[embarcacion]);
            agrupado[embarcacion] = this.filtrarRegistrosBombasDuplicados(agrupado[embarcacion]);
        }
        const embarcacionesOrdenadas = Object.keys(agrupado).sort();
        const resultadoOrdenado = {};
        for (const embarcacion of embarcacionesOrdenadas) {
            resultadoOrdenado[embarcacion] = agrupado[embarcacion];
        }
        this.logger.log(`Resultados agrupados en ${Object.keys(resultadoOrdenado).length} embarcaciones (ordenadas)`);
        return resultadoOrdenado;
    }
    agruparPorEmbarcacionConLimitePorTabla(resultados, limit) {
        const agrupado = {};
        const agrupadoPorTabla = {};
        for (const { registros } of resultados) {
            for (const registro of registros) {
                const embarcacion = registro.tabla || registro.Tabla;
                const reporte = registro.Reporte || registro.reporte;
                if (embarcacion && reporte) {
                    if (!agrupadoPorTabla[embarcacion]) {
                        agrupadoPorTabla[embarcacion] = {};
                    }
                    if (!agrupadoPorTabla[embarcacion][reporte]) {
                        agrupadoPorTabla[embarcacion][reporte] = [];
                    }
                    agrupadoPorTabla[embarcacion][reporte].push(registro);
                }
            }
        }
        for (const embarcacion in agrupadoPorTabla) {
            agrupado[embarcacion] = [];
            for (const reporte in agrupadoPorTabla[embarcacion]) {
                const registrosTabla = agrupadoPorTabla[embarcacion][reporte].sort((a, b) => {
                    const fechaA = new Date(a.fecha).getTime();
                    const fechaB = new Date(b.fecha).getTime();
                    return fechaB - fechaA;
                });
                const registrosLimitados = registrosTabla.slice(0, limit);
                agrupado[embarcacion].push(...registrosLimitados);
            }
            agrupado[embarcacion] = this.ordenarRegistrosPorReporteYFecha(agrupado[embarcacion]);
        }
        const embarcacionesOrdenadas = Object.keys(agrupado).sort();
        const resultadoOrdenado = {};
        for (const embarcacion of embarcacionesOrdenadas) {
            resultadoOrdenado[embarcacion] = agrupado[embarcacion];
        }
        this.logger.log(`Resultados agrupados con límite ${limit} por tabla en ${Object.keys(resultadoOrdenado).length} embarcaciones (ordenadas)`);
        return resultadoOrdenado;
    }
    aplicarFiltroBombas(agrupado, sistema, limit) {
        const esSistemaBombas = this.sistemaConfigService.esSistemaBombas(sistema);
        if (esSistemaBombas && (!limit || limit === 1)) {
            const filtrado = {};
            for (const [embarcacion, registros] of Object.entries(agrupado)) {
                if (registros.length > 0) {
                    const registrosBnhas = registros.filter((r) => r.Reporte === 'bnwas' ||
                        r.reporte === 'bnwas' ||
                        r.Reporte === 'bomba' ||
                        r.reporte === 'bomba');
                    if (registrosBnhas.length > 0) {
                        const registroConsolidado = this.consolidarRegistrosBnhas(registrosBnhas);
                        filtrado[embarcacion] = [registroConsolidado];
                    }
                    else {
                        filtrado[embarcacion] = [registros[0]];
                    }
                }
            }
            this.logger.log(`Filtro de bombas aplicado: ${Object.keys(filtrado).length} embarcaciones`);
            return filtrado;
        }
        if (limit && limit > 1) {
            const limitado = {};
            for (const [embarcacion, registros] of Object.entries(agrupado)) {
                limitado[embarcacion] = registros.slice(0, limit);
            }
            return limitado;
        }
        return agrupado;
    }
    aplicarLimiteGeneral(agrupado, limit) {
        const limitado = {};
        for (const [embarcacion, registros] of Object.entries(agrupado)) {
            limitado[embarcacion] = registros.slice(0, limit);
        }
        return limitado;
    }
    ordenarRegistrosPorReporteYFecha(registros) {
        return registros.sort((a, b) => {
            const reporteA = a.Reporte || a.reporte;
            const reporteB = b.Reporte || b.reporte;
            const prioridadA = this.prioridadReportes[reporteA] || 999;
            const prioridadB = this.prioridadReportes[reporteB] || 999;
            if (prioridadA !== prioridadB) {
                return prioridadA - prioridadB;
            }
            const fechaA = new Date(a.fecha).getTime();
            const fechaB = new Date(b.fecha).getTime();
            return fechaB - fechaA;
        });
    }
    filtrarRegistrosBombasDuplicados(registros) {
        const registrosFiltrados = [];
        let bombaEncontrada = false;
        for (const registro of registros) {
            const esBomba = registro.Reporte === 'bomba' || registro.reporte === 'bomba';
            if (esBomba) {
                if (!bombaEncontrada) {
                    registrosFiltrados.push(registro);
                    bombaEncontrada = true;
                }
            }
            else {
                registrosFiltrados.push(registro);
            }
        }
        return registrosFiltrados;
    }
    consolidarRegistrosBnhas(registrosBnhas) {
        const registroBase = registrosBnhas[0];
        const bomba7 = registrosBnhas.find((r) => r.bombaachique === '7' || r.bnwas_energia !== null);
        const bomba8 = registrosBnhas.find((r) => r.bombaachique === '8' || r.bnwas_on_off !== null);
        const bomba9 = registrosBnhas.find((r) => r.bombaachique === '9' || r.bnwas_alarma !== null);
        return {
            idmensaje: registroBase.idmensaje,
            reporte: 'bnwas',
            tabla: registroBase.tabla || registroBase.Tabla,
            fecha: registroBase.fecha,
            latitud: registroBase.latitud,
            longitud: registroBase.longitud,
            speed: registroBase.speed,
            header: registroBase.header,
            bombaachique: bomba7?.bombaachique ||
                bomba8?.bombaachique ||
                bomba9?.bombaachique ||
                null,
            bnwas_energia: bomba7?.bnwas_energia || null,
            bnwas_on_off: bomba8?.bnwas_on_off || null,
            bnwas_alarma: bomba9?.bnwas_alarma || null,
            bnwas_geocerca: registroBase.bnwas_geocerca,
            canal13: null,
            canal14: null,
            canal15: null,
            canal16: null,
            canal17: null,
            canal18: null,
            canal19: null,
            canal20: null,
            canal21: null,
            canal22: null,
            canal23: null,
            canal24: null,
            canal25: null,
            canal99: registroBase.canal99,
        };
    }
};
exports.ResultAggregatorService = ResultAggregatorService;
exports.ResultAggregatorService = ResultAggregatorService = ResultAggregatorService_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [sistema_config_service_1.SistemaConfigService])
], ResultAggregatorService);
//# sourceMappingURL=result-aggregator.service.js.map