"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var QueryOrchestratorService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueryOrchestratorService = void 0;
const common_1 = require("@nestjs/common");
const sequelize_1 = require("sequelize");
const database_service_1 = require("../database/database.service");
const concurrency_service_1 = require("./concurrency.service");
const query_builder_service_1 = require("./query-builder.service");
const data_processor_service_1 = require("./data-processor.service");
const sistema_config_service_1 = require("./sistema-config.service");
let QueryOrchestratorService = QueryOrchestratorService_1 = class QueryOrchestratorService {
    databaseService;
    concurrencyService;
    queryBuilderService;
    dataProcessorService;
    sistemaConfigService;
    logger = new common_1.Logger(QueryOrchestratorService_1.name);
    constructor(databaseService, concurrencyService, queryBuilderService, dataProcessorService, sistemaConfigService) {
        this.databaseService = databaseService;
        this.concurrencyService = concurrencyService;
        this.queryBuilderService = queryBuilderService;
        this.dataProcessorService = dataProcessorService;
        this.sistemaConfigService = sistemaConfigService;
    }
    async ejecutarConsultaSistemaEspecifico(dto) {
        const tablas = this.sistemaConfigService.getTablasPorSistema(dto.sistema);
        if (!tablas) {
            throw new Error(`Sistema ${dto.sistema} no encontrado`);
        }
        const tareas = tablas.map((tabla) => () => this.traerRegistrosSistema(dto.sistema, tabla, dto)
            .then((registros) => ({ sistema: dto.sistema, tabla, registros }))
            .catch((error) => {
            this.logger.warn(`Error consultando tabla ${tabla}: ${error.message}`);
            return { sistema: dto.sistema, tabla, registros: [] };
        }));
        this.logger.log(`Ejecutando ${tareas.length} consultas con concurrencia limitada para sistema ${dto.sistema}`);
        return await this.concurrencyService.executeWithLimitedConcurrency(tareas);
    }
    async ejecutarConsultaTodosLosSistemas(dto) {
        const tareas = [];
        const sistemaTablaMap = this.sistemaConfigService.getSistemaTablaMap();
        if (dto.dbKey) {
            for (const [sistema, tablas] of Object.entries(sistemaTablaMap)) {
                for (const tabla of tablas) {
                    tareas.push(() => this.traerRegistrosSistema(sistema, tabla, dto)
                        .then((registros) => ({ sistema, tabla, registros }))
                        .catch((error) => {
                        this.logger.warn(`Error consultando ${sistema}/${tabla}: ${error.message}`);
                        return { sistema, tabla, registros: [] };
                    }));
                }
            }
        }
        else {
            try {
                const todasLasTablas = this.sistemaConfigService.getTodasLasTablas();
                this.logger.log(`🎯 FASE 2: Iniciando filtrado inteligente para ${todasLasTablas.length} tablas únicas`);
                const databaseTableMap = await this.databaseService.getActiveDatabasesWithTables('TASA', todasLasTablas);
                for (const [sistema, tablas] of Object.entries(sistemaTablaMap)) {
                    for (const tabla of tablas) {
                        const basesConTabla = Object.keys(databaseTableMap).filter((dbKey) => databaseTableMap[dbKey].includes(tabla));
                        if (basesConTabla.length > 0) {
                            this.logger.debug(`✅ Tabla ${tabla} encontrada en ${basesConTabla.length} bases activas`);
                            tareas.push(() => this.traerRegistrosSistemaOptimizado(sistema, tabla, dto, basesConTabla)
                                .then((registros) => ({ sistema, tabla, registros }))
                                .catch((error) => {
                                this.logger.warn(`Error consultando ${sistema}/${tabla}: ${error.message}`);
                                return { sistema, tabla, registros: [] };
                            }));
                        }
                        else {
                            this.logger.debug(`⚠️ Tabla ${tabla} no encontrada en ninguna base activa, omitiendo`);
                        }
                    }
                }
                const basesActivas = Object.keys(databaseTableMap).length;
                const totalConsultas = tareas.length;
                this.logger.log(`🎯 FILTRADO INTELIGENTE APLICADO: ${totalConsultas} consultas válidas (${basesActivas} bases activas)`);
            }
            catch (error) {
                this.logger.warn(`⚠️ Error en filtrado inteligente, usando método tradicional: ${error.message}`);
                for (const [sistema, tablas] of Object.entries(sistemaTablaMap)) {
                    for (const tabla of tablas) {
                        tareas.push(() => this.traerRegistrosSistema(sistema, tabla, dto)
                            .then((registros) => ({ sistema, tabla, registros }))
                            .catch((error) => {
                            this.logger.warn(`Error consultando ${sistema}/${tabla}: ${error.message}`);
                            return { sistema, tabla, registros: [] };
                        }));
                    }
                }
            }
        }
        this.logger.log(`Ejecutando ${tareas.length} consultas con concurrencia limitada`);
        return await this.concurrencyService.executeWithLimitedConcurrency(tareas);
    }
    async traerRegistrosSistemaOptimizado(sistema, tabla, dto, basesConTabla) {
        this.logger.debug(`🎯 Consultando tabla ${tabla} en ${basesConTabla.length} bases optimizadas`);
        const tareasDB = basesConTabla.map((dbKey) => async () => {
            try {
                const sequelize = await this.databaseService.getConnection('TASA', dbKey);
                const query = this.queryBuilderService.buildTableQuery(tabla, dto);
                const registros = await sequelize.query(query.query, {
                    type: sequelize_1.QueryTypes.SELECT,
                    replacements: query.replacements,
                });
                return registros.map((registro) => this.dataProcessorService.procesarRegistro(registro, sistema, tabla, dbKey));
            }
            catch (error) {
                this.logger.warn(`Error consultando ${dbKey}/${tabla}: ${error.message}`);
                return [];
            }
        });
        const resultadosDB = await this.concurrencyService.executeWithLimitedConcurrency(tareasDB);
        return resultadosDB.flat();
    }
    async traerRegistrosSistema(sistema, tabla, dto) {
        let basesFiltradas;
        if (dto.dbKey) {
            basesFiltradas = [dto.dbKey];
        }
        else {
            const todasLasBases = this.getBasesDatosDisponibles('TASA');
            basesFiltradas = todasLasBases;
            this.logger.log(`📊 Consultando ${basesFiltradas.length} bases de datos para tabla: ${tabla}`);
        }
        const tareasDB = basesFiltradas.map((dbKey) => async () => {
            try {
                const sequelize = await this.databaseService.getConnection('TASA', dbKey);
                const query = this.queryBuilderService.buildTableQuery(tabla, dto);
                const registros = await sequelize.query(query.query, {
                    type: sequelize_1.QueryTypes.SELECT,
                    replacements: query.replacements,
                });
                return registros.map((registro) => this.dataProcessorService.procesarRegistro(registro, sistema, tabla, dbKey));
            }
            catch (error) {
                this.logger.warn(`Error consultando ${dbKey}/${tabla}: ${error.message}`);
                return [];
            }
        });
        const resultadosDB = await this.concurrencyService.executeWithLimitedConcurrency(tareasDB);
        return resultadosDB.flat();
    }
    getBasesDatosDisponibles(tipo) {
        return this.databaseService.getAvailableDatabases(tipo);
    }
};
exports.QueryOrchestratorService = QueryOrchestratorService;
exports.QueryOrchestratorService = QueryOrchestratorService = QueryOrchestratorService_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [database_service_1.DatabaseService,
        concurrency_service_1.ConcurrencyService,
        query_builder_service_1.QueryBuilderService,
        data_processor_service_1.DataProcessorService,
        sistema_config_service_1.SistemaConfigService])
], QueryOrchestratorService);
//# sourceMappingURL=query-orchestrator.service.js.map