import { DatabaseService } from '../database/database.service';
import { ConcurrencyService } from './concurrency.service';
import { QueryBuilderService } from './query-builder.service';
import { DataProcessorService } from './data-processor.service';
import { SistemaConfigService } from './sistema-config.service';
import { ConsultaGeneralDto } from '../dto/consulta-tasa.dto';
export interface QueryResult {
    sistema: string;
    tabla: string;
    registros: any[];
}
export declare class QueryOrchestratorService {
    private readonly databaseService;
    private readonly concurrencyService;
    private readonly queryBuilderService;
    private readonly dataProcessorService;
    private readonly sistemaConfigService;
    private readonly logger;
    constructor(databaseService: DatabaseService, concurrencyService: ConcurrencyService, queryBuilderService: QueryBuilderService, dataProcessorService: DataProcessorService, sistemaConfigService: SistemaConfigService);
    ejecutarConsultaSistemaEspecifico(dto: ConsultaGeneralDto): Promise<QueryResult[]>;
    ejecutarConsultaTodosLosSistemas(dto: ConsultaGeneralDto): Promise<QueryResult[]>;
    private traerRegistrosSistemaOptimizado;
    private traerRegistrosSistema;
    private getBasesDatosDisponibles;
}
