"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var QueryBuilderService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueryBuilderService = void 0;
const common_1 = require("@nestjs/common");
let QueryBuilderService = QueryBuilderService_1 = class QueryBuilderService {
    logger = new common_1.Logger(QueryBuilderService_1.name);
    buildTableQuery(tabla, dto) {
        let query = `SELECT * FROM ${tabla}`;
        const whereConditions = [];
        const replacements = {};
        if (dto.desde) {
            whereConditions.push('fecha >= :desde');
            replacements.desde = dto.desde;
        }
        if (dto.hasta) {
            whereConditions.push('fecha <= :hasta');
            replacements.hasta = dto.hasta;
        }
        if (whereConditions.length > 0) {
            query += ` WHERE ${whereConditions.join(' AND ')}`;
        }
        query += ' ORDER BY fecha DESC';
        if (dto.limit) {
            query += ` LIMIT :limit`;
            replacements.limit = dto.limit;
        }
        return { query, replacements };
    }
    buildTableExistsQuery(tabla) {
        return `SELECT 1 FROM ${tabla} LIMIT 1`;
    }
    buildCountQuery(tabla, dto) {
        let query = `SELECT COUNT(*) as count FROM ${tabla}`;
        const whereConditions = [];
        const replacements = {};
        if (dto?.desde) {
            whereConditions.push('fecha >= :desde');
            replacements.desde = dto.desde;
        }
        if (dto?.hasta) {
            whereConditions.push('fecha <= :hasta');
            replacements.hasta = dto.hasta;
        }
        if (whereConditions.length > 0) {
            query += ` WHERE ${whereConditions.join(' AND ')}`;
        }
        return { query, replacements };
    }
    buildLastRecordQuery(tabla) {
        return `SELECT * FROM ${tabla} ORDER BY fecha DESC LIMIT 1`;
    }
    buildRecentDataQuery(tabla, hoursBack = 24) {
        const query = `SELECT 1 FROM ${tabla} WHERE fecha >= DATE_SUB(NOW(), INTERVAL :hours HOUR) LIMIT 1`;
        const replacements = { hours: hoursBack };
        return { query, replacements };
    }
    buildHealthCheckQuery(tabla) {
        return `SELECT 
      COUNT(*) as total_records,
      MAX(fecha) as last_record_date,
      MIN(fecha) as first_record_date
    FROM ${tabla}`;
    }
    validateTableName(tabla) {
        const validTableNameRegex = /^[a-zA-Z0-9_]+$/;
        return validTableNameRegex.test(tabla);
    }
    escapeTableName(tabla) {
        if (!this.validateTableName(tabla)) {
            throw new Error(`Nombre de tabla inválido: ${tabla}`);
        }
        return `\`${tabla}\``;
    }
};
exports.QueryBuilderService = QueryBuilderService;
exports.QueryBuilderService = QueryBuilderService = QueryBuilderService_1 = __decorate([
    (0, common_1.Injectable)()
], QueryBuilderService);
//# sourceMappingURL=query-builder.service.js.map