"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const common_1 = require("@nestjs/common");
const app_module_1 = require("./app.module");
const swagger_1 = require("@nestjs/swagger");
async function bootstrap() {
    const app = await core_1.NestFactory.create(app_module_1.AppModule);
    app.enableCors({
        origin: true,
        credentials: true,
    });
    app.use((req, res, next) => {
        const originalUrl = req.originalUrl || req.url;
        const rutasPublicas = [
            '/tasa/health',
            '/tasa/empresas',
            '/tasa/bases-datos',
            '/tasa/conexiones/stats',
            '/tasa/api/docs',
            '/tasa/api/docs-json',
        ];
        if (rutasPublicas.includes(originalUrl)) {
            return next();
        }
        const authPattern = /^\/user=([^&]+)&password=([^\/]+)(?:\/(.*))?$/;
        const match = originalUrl.match(authPattern);
        if (!match) {
            if (originalUrl.startsWith('/tasa')) {
                res.status(401).json({
                    message: 'Credenciales requeridas: /user=username&password=password/ruta',
                });
                return;
            }
            return next();
        }
        const [, username, password, trailing] = match;
        const expectedUsername = process.env.BASIC_AUTH_USER || 'tasa_client';
        const expectedPassword = process.env.BASIC_AUTH_PASSWORD || 'tasa_client_2024';
        if (username !== expectedUsername || password !== expectedPassword) {
            res.status(401).json({ message: 'Credenciales inválidas' });
            return;
        }
        req.urlAuthAuthorized = true;
        let cleanUrl = trailing ? `/${trailing}` : '/tasa';
        if (!cleanUrl.startsWith('/'))
            cleanUrl = '/' + cleanUrl;
        req.url = cleanUrl;
        req.originalUrl = cleanUrl;
        return next();
    });
    app.useGlobalPipes(new common_1.ValidationPipe({
        transform: true,
        whitelist: true,
    }));
    const config = new swagger_1.DocumentBuilder()
        .setTitle('Tasa Service API')
        .setDescription('API para el cliente Tasa - Gestión de datos pesqueros')
        .setVersion('1.0')
        .addBearerAuth()
        .build();
    const document = swagger_1.SwaggerModule.createDocument(app, config);
    swagger_1.SwaggerModule.setup('tasa/api/docs', app, document);
    const port = process.env.PORT || 3002;
    await app.listen(port);
    console.log(`Tasa Service is running on port ${port}`);
    console.log(`📚 Swagger docs available at http://localhost:${port}/tasa/api/docs`);
}
bootstrap();
//# sourceMappingURL=main.js.map