export interface RegistroTasa {
    idMensaje: string;
    reporte: string;
    tabla: string;
    fecha: string;
    latitud: string | null;
    longitud: string | null;
    speed: string | null;
    header: string | null;
    canal8?: string | null;
    canal9?: string | null;
    canal10?: string | null;
    canal11?: string | null;
    canal12?: string | null;
    canal13?: string | null;
    canal14?: string | null;
    canal15?: string | null;
    canal16?: string | null;
    canal17?: string | null;
    canal18?: string | null;
    canal19?: string | null;
    canal20?: string | null;
    canal21?: string | null;
    canal22?: string | null;
    canal23?: string | null;
    canal24?: string | null;
    canal25?: string | null;
    canal99?: string | null;
}
export interface RegistroBomba {
    idMensaje: string;
    Reporte: string;
    Tabla: string;
    fecha: string;
    latitud: string | null;
    longitud: string | null;
    bomba: string;
    distancia: string | null;
    estado: string | null;
}
export interface RegistroBnwas {
    idMensaje: string;
    reporte: string;
    tabla: string;
    fecha: string;
    latitud: string | null;
    longitud: string | null;
    speed: string | null;
    header: string | null;
    bombaachique: string | null;
    bnwas_energia: string | null;
    bnwas_on_off: string | null;
    bnwas_alarma: string | null;
    bnwas_geocerca: string | null;
    canal13: string | null;
    canal14: string | null;
    canal15: string | null;
    canal16: string | null;
    canal17: string | null;
    canal18: string | null;
    canal19: string | null;
    canal20: string | null;
    canal21: string | null;
    canal22: string | null;
    canal23: string | null;
    canal24: string | null;
    canal25: string | null;
    canal99: string | null;
}
export interface ConsultaOptions {
    limit?: number;
    sistema?: string;
    desde?: string;
    hasta?: string;
}
export interface SistemaTablaMap {
    [sistema: string]: string[];
}
export interface ResultadoConsulta {
    [tabla: string]: (RegistroTasa | RegistroBomba | RegistroBnwas)[];
}
export interface HealthCheckResult {
    status: 'healthy' | 'degraded' | 'unhealthy';
    connections: {
        [key: string]: boolean;
    };
    timestamp: string;
    totalDatabases: number;
    healthyDatabases: number;
}
