"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsultaGeneralDto = exports.ConsultaTasaDto = void 0;
const class_validator_1 = require("class-validator");
const class_transformer_1 = require("class-transformer");
const swagger_1 = require("@nestjs/swagger");
class ConsultaTasaDto {
    limit = 1;
    sistema;
    desde;
    hasta;
    dbKey;
}
exports.ConsultaTasaDto = ConsultaTasaDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Límite de registros a retornar',
        example: 10,
        minimum: 1,
        maximum: 1000,
    }),
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(1),
    (0, class_validator_1.Max)(1000),
    __metadata("design:type", Number)
], ConsultaTasaDto.prototype, "limit", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Sistema específico a consultar',
        example: 'slave1',
        enum: [
            'slave1',
            'slave2',
            'restfull',
            'slave3',
            'slave4',
            'slave5',
            'slave6',
            'bomba',
            'bnwas',
            'pesca',
            'comp1',
            'comp2',
            'planta',
        ],
    }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsIn)([
        'slave1',
        'slave2',
        'restfull',
        'slave3',
        'slave4',
        'slave5',
        'slave6',
        'bomba',
        'bnwas',
        'pesca',
        'comp1',
        'comp2',
        'planta',
    ]),
    __metadata("design:type", String)
], ConsultaTasaDto.prototype, "sistema", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Fecha de inicio (YYYY-MM-DD)',
        example: '2025-01-01',
    }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    __metadata("design:type", String)
], ConsultaTasaDto.prototype, "desde", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Fecha de fin (YYYY-MM-DD)',
        example: '2025-01-31',
    }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    __metadata("design:type", String)
], ConsultaTasaDto.prototype, "hasta", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Código de la base de datos específica (ej: TASA17, TASA21)',
        example: 'TASA17',
    }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_transformer_1.Transform)(({ value }) => value?.toUpperCase()),
    __metadata("design:type", String)
], ConsultaTasaDto.prototype, "dbKey", void 0);
class ConsultaGeneralDto extends ConsultaTasaDto {
}
exports.ConsultaGeneralDto = ConsultaGeneralDto;
//# sourceMappingURL=consulta-tasa.dto.js.map