"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var DatabaseService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseService = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const sequelize_typescript_1 = require("sequelize-typescript");
let DatabaseService = DatabaseService_1 = class DatabaseService {
    configService;
    logger = new common_1.Logger(DatabaseService_1.name);
    connections = new Map();
    companyDatabases = {
        TASA: {
            TASA17: 'perupcs_01230195sky157c',
            TASA21: 'perupcs_01277742sky2223',
            TASA22: 'perupcs_01448290skyf527',
            TASA23: 'perupcs_01351604skydcc1',
            TASA31: 'perupcs_01351602skyd4b7-31',
            TASA32: 'perupcs_01351598skyc4a3',
            TASA34: 'perupcs_01875412sky5361',
            TASA35: 'perupcs_01351597sky409e',
            TASA36: 'perupcs_01351570sky5417',
            TASA37: 'perupcs_01351601sky50b2',
            TASA38: 'perupcs_01351599sky48a8',
            TASA41: 'perupcs_01230252sky7a99',
            TASA42: 'perupcs_01190101sky8e66',
            TASA43: 'perupcs_01470159skyd448',
            TASA44: 'perupcs_01226799skyc328',
            TASA51: 'perupcs_01238630sky063b',
            TASA52: 'perupcs_01412175sky67c8',
            TASA53: 'perupcs_01230221sky7dfe',
            TASA54: 'perupcs_01238631sky8a40',
            TASA55: 'perupcs_01238637skya25e',
            TASA56: 'perupcs_01230237skybe4e',
            TASA57: 'perupcs_01230292sky1b61',
            TASA58: 'perupcs_01183404skye799',
            TASA59: 'perupcs_01238636sky1e59',
            TASA61: 'perupcs_01277705sky0d6a',
            TASA71: 'perupcs_01230240sky4a5d',
            TASA111: 'perupcs_01277737sky8e0a',
            TASA210: 'perupcs_01190099sky865c',
            TASA218: 'perupcs_01470172sky8889',
            TASA310: 'perupcs_01343897sky5a3a',
            TASA314: 'perupcs_01412168skycba5',
            TASA315: 'perupcs_01351590skya47b',
            TASA411: 'perupcs_01470145sky9c02',
            TASA412: 'perupcs_01230291sky975c',
            TASA413: 'perupcs_01351600skyccad',
            TASA414: 'perupcs_01343881sky19ea',
            TASA416: 'perupcs_01351589sky2076',
            TASA417: 'perupcs_01230192sky896d',
            TASA418: 'perupcs_01351592skyac85',
            TASA419: 'perupcs_01875416sky6375',
            TASA420: 'perupcs_01277714skyb197',
            TASA424: 'perupcs_01351566sky4403',
            TASA425: 'perupcs_01875420sky7389',
            TASA426: 'perupcs_01351595sky3894',
            TASA427: 'perupcs_01470152sky3825',
            TASA428: 'perupcs_01351602skyd4b7',
        },
    };
    constructor(configService) {
        this.configService = configService;
    }
    async getActiveDatabases(companyCode, tabla) {
        const databases = this.companyDatabases[companyCode];
        if (!databases) {
            throw new Error(`Empresa ${companyCode} no configurada`);
        }
        const activeDatabases = [];
        const config = this.getBaseConfig(companyCode);
        const checkPromises = Object.keys(databases).map(async (dbKey) => {
            try {
                const databaseName = databases[dbKey];
                const quickConnection = new sequelize_typescript_1.Sequelize({
                    ...config,
                    database: databaseName,
                    pool: {
                        max: 1,
                        min: 0,
                        acquire: 5000,
                        idle: 1000,
                        evict: 500,
                    },
                    logging: false,
                });
                const [tableExists] = await quickConnection.query(`SHOW TABLES LIKE '${tabla}'`, { type: 'SELECT' });
                if (tableExists && tableExists.length > 0) {
                    const [results] = await quickConnection.query(`SELECT 1 FROM ${tabla} LIMIT 1`, { type: 'SELECT' });
                    if (results && results.length > 0) {
                        activeDatabases.push(dbKey);
                        this.logger.debug(`✅ Base activa encontrada: ${dbKey} (tabla: ${tabla})`);
                    }
                    else {
                        this.logger.debug(`📋 Tabla ${tabla} existe pero sin datos en: ${dbKey}`);
                    }
                }
                else {
                    this.logger.debug(`❌ Tabla ${tabla} no existe en: ${dbKey}`);
                }
                await quickConnection.close();
            }
            catch (error) {
                this.logger.debug(`❌ Error verificando ${dbKey}: ${error.message}`);
            }
        });
        await Promise.allSettled(checkPromises);
        this.logger.log(`🎯 Bases activas encontradas: ${activeDatabases.length}/${Object.keys(databases).length} para tabla: ${tabla}`);
        return activeDatabases;
    }
    async getConnection(companyCode, dbKey) {
        const connectionKey = `${companyCode}_${dbKey}`;
        if (this.connections.has(connectionKey)) {
            const existingConnection = this.connections.get(connectionKey);
            this.logger.debug(`♻️ Reutilizando conexión para ${connectionKey}`);
            return existingConnection;
        }
        const databaseName = this.getDatabaseName(companyCode, dbKey);
        if (!databaseName) {
            throw new Error(`No se encontró configuración para ${companyCode}:${dbKey}`);
        }
        const config = this.getBaseConfig(companyCode);
        const sequelize = new sequelize_typescript_1.Sequelize({
            ...config,
            database: databaseName,
            pool: {
                max: 4,
                min: 0,
                acquire: 5000,
                idle: 8000,
                evict: 2000,
            },
            logging: false,
            retry: {
                max: 3,
            },
        });
        try {
            await sequelize.authenticate();
            this.connections.set(connectionKey, sequelize);
            this.logger.debug(`🔗 Nueva conexión creada para ${connectionKey}`);
            setTimeout(() => {
                void (async () => {
                    try {
                        if (this.connections.has(connectionKey)) {
                            await sequelize.close();
                            this.connections.delete(connectionKey);
                            this.logger.debug(`🔒 Conexión cerrada automáticamente para ${connectionKey}`);
                        }
                    }
                    catch (error) {
                        this.logger.warn(`Error cerrando conexión automáticamente ${connectionKey}:`, error);
                    }
                })();
            }, 10000);
            return sequelize;
        }
        catch (error) {
            this.logger.error(`❌ Error conectando a ${connectionKey}:`, error);
            throw error;
        }
    }
    async getAllConnectionsForCompany(companyCode) {
        const companyConnections = new Map();
        const databases = this.companyDatabases[companyCode];
        if (!databases) {
            throw new Error(`Empresa ${companyCode} no configurada`);
        }
        const connectionPromises = Object.keys(databases).map(async (dbKey) => {
            try {
                const connection = await this.getConnection(companyCode, dbKey);
                companyConnections.set(dbKey, connection);
            }
            catch (error) {
                this.logger.warn(`No se pudo conectar a ${companyCode}:${dbKey}`, error);
            }
        });
        await Promise.allSettled(connectionPromises);
        return companyConnections;
    }
    getDatabaseName(companyCode, dbKey) {
        return this.companyDatabases[companyCode]?.[dbKey] || null;
    }
    getBaseConfig(_companyCode) {
        const config = {
            host: this.configService.get('DB_HOST', '208.109.188.8'),
            port: this.configService.get('DB_PORT', 3306),
            username: this.configService.get('DB_USERNAME', 'perupcs_pcbarcoscontrolssac'),
            password: this.configService.get('DB_PASSWORD', 'pcbarcossaccontrols123*'),
            dialect: 'mysql',
        };
        this.logger.debug(`🔍 CONFIG DEBUG - Host: ${config.host}, Port: ${config.port}, Username: ${config.username}, Password: ${config.password ? '***SET***' : 'EMPTY'}`);
        return config;
    }
    getAvailableCompanies() {
        return Object.keys(this.companyDatabases);
    }
    getAvailableDatabases(companyCode) {
        return Object.keys(this.companyDatabases[companyCode] || {});
    }
    async onModuleDestroy() {
        const closePromises = Array.from(this.connections.values()).map((connection) => connection.close());
        await Promise.allSettled(closePromises);
        this.connections.clear();
        this.logger.log('🔒 Todas las conexiones de base de datos cerradas');
    }
    async forceCloseAllConnections() {
        this.logger.log(`🔒 Forzando cierre de ${this.connections.size} conexiones`);
        const closePromises = Array.from(this.connections.entries()).map(async ([key, connection]) => {
            try {
                await connection.close();
                this.connections.delete(key);
                this.logger.debug(`🔒 Conexión ${key} cerrada forzadamente`);
            }
            catch (error) {
                this.logger.warn(`Error cerrando conexión ${key}:`, error);
            }
        });
        await Promise.allSettled(closePromises);
        this.connections.clear();
        this.logger.log('🔒 Todas las conexiones cerradas forzadamente');
    }
    getConnectionStats() {
        const activeConnections = [];
        for (const [key, _connection] of this.connections.entries()) {
            activeConnections.push({
                database: key,
                status: 'active',
            });
        }
        return {
            totalConnectionsCreated: this.connections.size,
            currentlyActiveConnections: activeConnections.length,
            activeConnections,
        };
    }
    async healthCheck() {
        const health = {};
        for (const [key, connection] of this.connections) {
            try {
                await connection.authenticate();
                health[key] = true;
            }
            catch (error) {
                health[key] = false;
                this.logger.warn(`Conexión ${key} no saludable:`, error);
            }
        }
        return health;
    }
    async getActiveDatabasesWithTables(companyCode, tablasRequeridas) {
        const databases = this.companyDatabases[companyCode];
        if (!databases) {
            throw new Error(`Empresa ${companyCode} no configurada`);
        }
        const databaseTableMap = {};
        const config = this.getBaseConfig(companyCode);
        const checkPromises = Object.keys(databases).map(async (dbKey) => {
            try {
                const databaseName = databases[dbKey];
                const quickConnection = new sequelize_typescript_1.Sequelize({
                    ...config,
                    database: databaseName,
                    pool: {
                        max: 1,
                        min: 0,
                        acquire: 5000,
                        idle: 1000,
                        evict: 500,
                    },
                    logging: false,
                });
                const tablasExistentes = [];
                for (const tabla of tablasRequeridas) {
                    try {
                        const [tableExists] = await quickConnection.query(`SHOW TABLES LIKE '${tabla}'`, { type: 'SELECT' });
                        if (tableExists && Object.keys(tableExists).length > 0) {
                            const [hasData] = await quickConnection.query(`SELECT 1 FROM ${tabla} LIMIT 1`, { type: 'SELECT' });
                            if (hasData && Object.keys(hasData).length > 0) {
                                tablasExistentes.push(tabla);
                                this.logger.debug(`✅ Tabla ${tabla} existe y tiene datos en: ${dbKey}`);
                            }
                            else {
                                this.logger.debug(`📋 Tabla ${tabla} existe pero sin datos en: ${dbKey}`);
                            }
                        }
                    }
                    catch (error) {
                        this.logger.debug(`❌ Error verificando tabla ${tabla} en ${dbKey}: ${error.message}`);
                    }
                }
                if (tablasExistentes.length > 0) {
                    databaseTableMap[dbKey] = tablasExistentes;
                    this.logger.debug(`🎯 Base ${dbKey}: ${tablasExistentes.length} tablas activas`);
                }
                await quickConnection.close();
            }
            catch (error) {
                this.logger.debug(`❌ Error verificando base ${dbKey}: ${error.message}`);
            }
        });
        const batchSize = 10;
        for (let i = 0; i < checkPromises.length; i += batchSize) {
            const batch = checkPromises.slice(i, i + batchSize);
            await Promise.allSettled(batch);
        }
        const totalBases = Object.keys(databases).length;
        const basesActivas = Object.keys(databaseTableMap).length;
        const totalTablas = Object.values(databaseTableMap).reduce((sum, tablas) => sum + tablas.length, 0);
        this.logger.log(`🎯 FILTRADO INTELIGENTE: ${basesActivas}/${totalBases} bases activas, ${totalTablas} consultas válidas`);
        return databaseTableMap;
    }
};
exports.DatabaseService = DatabaseService;
exports.DatabaseService = DatabaseService = DatabaseService_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], DatabaseService);
//# sourceMappingURL=database.service.js.map