import { OnModuleDestroy } from '@nestjs/common';
import { ConfigService } from '@nestjs/config';
import { Sequelize } from 'sequelize-typescript';
export interface DatabaseConfig {
    host: string;
    port: number;
    username: string;
    password: string;
    database: string;
    dialect: 'mysql' | 'postgres' | 'sqlite' | 'mariadb' | 'mssql';
}
export interface CompanyDatabaseConfig {
    [companyCode: string]: {
        [dbKey: string]: string;
    };
}
export declare class DatabaseService implements OnModuleDestroy {
    private configService;
    private readonly logger;
    private connections;
    private readonly companyDatabases;
    constructor(configService: ConfigService);
    getActiveDatabases(companyCode: string, tabla: string): Promise<string[]>;
    getConnection(companyCode: string, dbKey: string): Promise<Sequelize>;
    getAllConnectionsForCompany(companyCode: string): Promise<Map<string, Sequelize>>;
    private getDatabaseName;
    private getBaseConfig;
    getAvailableCompanies(): string[];
    getAvailableDatabases(companyCode: string): string[];
    onModuleDestroy(): Promise<void>;
    forceCloseAllConnections(): Promise<void>;
    getConnectionStats(): {
        totalConnectionsCreated: number;
        currentlyActiveConnections: number;
        activeConnections: {
            database: string;
            status: string;
        }[];
    };
    healthCheck(): Promise<{
        [key: string]: boolean;
    }>;
    getActiveDatabasesWithTables(companyCode: string, tablasRequeridas: string[]): Promise<{
        [dbKey: string]: string[];
    }>;
}
