"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UrlAuthMiddleware = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
let UrlAuthMiddleware = class UrlAuthMiddleware {
    configService;
    constructor(configService) {
        this.configService = configService;
    }
    use(req, res, next) {
        const originalUrl = req.originalUrl || req.url;
        console.log('🔍 Middleware - Original URL:', originalUrl);
        if (req.urlAuthAuthorized) {
            return next();
        }
        const rutasPublicas = [
            '/tasa/health',
            '/tasa/empresas',
            '/tasa/bases-datos',
            '/tasa/conexiones/stats',
        ];
        if (rutasPublicas.includes(originalUrl)) {
            return next();
        }
        const authPattern = /^\/user=([^&]+)&password=([^\/]+)(?:\/(.*))?$/;
        const match = originalUrl.match(authPattern);
        if (!match) {
            console.log('❌ No se encontraron credenciales en la URL');
            if (!originalUrl.startsWith('/tasa')) {
                return next();
            }
            throw new common_1.UnauthorizedException('Credenciales requeridas: /user=username&password=password/ruta');
        }
        const [, username, password, trailing] = match;
        console.log('✅ Credenciales encontradas:', { username, password: '***' });
        const expectedUsername = this.configService.get('BASIC_AUTH_USER') || 'tasa_client';
        const expectedPassword = this.configService.get('BASIC_AUTH_PASSWORD') || 'tasa_client_2024';
        console.log('🔑 Validando contra:', {
            expectedUsername,
            expectedPassword: '***',
        });
        if (username !== expectedUsername || password !== expectedPassword) {
            console.log('❌ Credenciales inválidas');
            throw new common_1.UnauthorizedException('Credenciales inválidas');
        }
        console.log('✅ Credenciales válidas');
        req.urlAuthAuthorized = true;
        let cleanUrl = trailing ? `/${trailing}` : '/tasa';
        if (!cleanUrl.startsWith('/'))
            cleanUrl = '/' + cleanUrl;
        console.log('🧹 URL limpia:', cleanUrl);
        req.url = cleanUrl;
        req.originalUrl = cleanUrl;
        console.log('🔄 Request modificado - url:', req.url);
        next();
    }
};
exports.UrlAuthMiddleware = UrlAuthMiddleware;
exports.UrlAuthMiddleware = UrlAuthMiddleware = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], UrlAuthMiddleware);
//# sourceMappingURL=url-auth.middleware.js.map