"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExalmarModule = void 0;
const common_1 = require("@nestjs/common");
const exalmar_controller_1 = require("./exalmar.controller");
const exalmar_service_1 = require("./exalmar.service");
const exalmar_database_module_1 = require("./database/exalmar-database.module");
const url_auth_middleware_1 = require("./auth/url-auth.middleware");
let ExalmarModule = class ExalmarModule {
    configure(consumer) {
        consumer
            .apply(url_auth_middleware_1.UrlAuthMiddleware)
            .exclude({ path: 'exalmar/health', method: common_1.RequestMethod.GET }, { path: 'exalmar/embarcaciones', method: common_1.RequestMethod.GET }, { path: 'exalmar/sistemas', method: common_1.RequestMethod.GET }, { path: 'exalmar/bases-datos', method: common_1.RequestMethod.GET })
            .forRoutes('exalmar');
    }
};
exports.ExalmarModule = ExalmarModule;
exports.ExalmarModule = ExalmarModule = __decorate([
    (0, common_1.Module)({
        imports: [exalmar_database_module_1.ExalmarDatabaseModule],
        controllers: [exalmar_controller_1.ExalmarController],
        providers: [exalmar_service_1.ExalmarService, url_auth_middleware_1.UrlAuthMiddleware],
        exports: [exalmar_service_1.ExalmarService],
    })
], ExalmarModule);
//# sourceMappingURL=exalmar.module.js.map