"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var ExalmarDatabaseService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExalmarDatabaseService = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const sequelize_typescript_1 = require("sequelize-typescript");
let ExalmarDatabaseService = ExalmarDatabaseService_1 = class ExalmarDatabaseService {
    configService;
    logger = new common_1.Logger(ExalmarDatabaseService_1.name);
    connections = new Map();
    exalmarDatabases = {
        EXALMAR: {
            DON_ALFREDO: 'perupcs_01864307sky767c',
            MARIANGELLA: 'perupcs_01864306skyf277',
            CARMENCITA: 'perupcs_01732500sky6c21',
            CRETA: 'perupcs_01864308skyfa81',
            RODAS: 'perupcs_01864316sky1aa9',
            CUZCO_4: 'perupcs_01739954sky75b7',
            ANCASH_2: 'perupcs_01863868sky11e9',
            CARIBE: 'perupcs_01343906skyfe67',
            BLANDI: 'perupcs_01448288skyed1d',
            MARIA_I: 'perupcs_01230244sky5a71',
            MARY: 'perupcs_01470155skyc434',
            POLAR_I: 'perupcs_01448308sky3d81',
            SANTA_ADELA_II: 'perupcs_01448305skyb172',
            REGION_CHAVIN_I: 'perupcs_01277747skyb63c',
            ERNESTINA: 'perupcs_01174740skyde61',
        },
    };
    constructor(configService) {
        this.configService = configService;
        this.logger.log('🚢 ExalmarDatabaseService inicializado');
    }
    async getActiveDatabases(embarcacionCode, tabla) {
        const databases = this.exalmarDatabases[embarcacionCode];
        if (!databases) {
            throw new Error(`Embarcación ${embarcacionCode} no configurada en EXALMAR`);
        }
        const activeDatabases = [];
        const config = this.getBaseConfig();
        const checkPromises = Object.keys(databases).map(async (dbKey) => {
            try {
                const databaseName = databases[dbKey];
                const quickConnection = new sequelize_typescript_1.Sequelize({
                    ...config,
                    database: databaseName,
                    pool: {
                        max: 1,
                        min: 0,
                        acquire: 5000,
                        idle: 1000,
                        evict: 500,
                    },
                    logging: false,
                });
                const [tableExists] = await quickConnection.query(`SHOW TABLES LIKE '${tabla}'`, { type: 'SELECT' });
                if (tableExists && tableExists.length > 0) {
                    const [results] = await quickConnection.query(`SELECT 1 FROM ${tabla} LIMIT 1`, { type: 'SELECT' });
                    if (results && results.length > 0) {
                        activeDatabases.push(dbKey);
                        this.logger.debug(`✅ Base activa EXALMAR encontrada: ${dbKey} (tabla: ${tabla})`);
                    }
                    else {
                        this.logger.debug(`📋 Tabla ${tabla} existe pero sin datos en EXALMAR: ${dbKey}`);
                    }
                }
                else {
                    this.logger.debug(`❌ Tabla ${tabla} no existe en EXALMAR: ${dbKey}`);
                }
                await quickConnection.close();
            }
            catch (error) {
                this.logger.debug(`❌ Error verificando EXALMAR ${dbKey}: ${error.message}`);
            }
        });
        await Promise.allSettled(checkPromises);
        this.logger.log(`🎯 Bases activas EXALMAR encontradas: ${activeDatabases.length}/${Object.keys(databases).length} para tabla: ${tabla}`);
        return activeDatabases;
    }
    async getConnection(embarcacionCode, dbKey) {
        const connectionKey = `EXALMAR_${embarcacionCode}_${dbKey}`;
        if (this.connections.has(connectionKey)) {
            const existingConnection = this.connections.get(connectionKey);
            this.logger.debug(`♻️ Reutilizando conexión EXALMAR para ${connectionKey}`);
            return existingConnection;
        }
        const databaseName = this.getDatabaseName(embarcacionCode, dbKey);
        if (!databaseName) {
            throw new Error(`No se encontró configuración EXALMAR para ${embarcacionCode}:${dbKey}`);
        }
        const config = this.getBaseConfig();
        const sequelize = new sequelize_typescript_1.Sequelize({
            ...config,
            database: databaseName,
            pool: {
                max: 2,
                min: 0,
                acquire: 5000,
                idle: 1000,
                evict: 500,
            },
            logging: false,
            retry: {
                max: 3,
            },
        });
        try {
            await sequelize.authenticate();
            this.connections.set(connectionKey, sequelize);
            this.logger.debug(`🔗 Nueva conexión EXALMAR creada para ${connectionKey}`);
            setTimeout(async () => {
                try {
                    if (this.connections.has(connectionKey)) {
                        await sequelize.close();
                        this.connections.delete(connectionKey);
                        this.logger.debug(`🔒 Conexión EXALMAR cerrada automáticamente para ${connectionKey}`);
                    }
                }
                catch (error) {
                    this.logger.warn(`Error cerrando conexión EXALMAR: ${error}`);
                }
            }, 5000);
            return sequelize;
        }
        catch (error) {
            this.logger.error(`❌ Error conectando a EXALMAR ${connectionKey}:`, error);
            throw error;
        }
    }
    async getAllConnectionsForExalmar() {
        const exalmarConnections = new Map();
        const databases = this.exalmarDatabases.EXALMAR;
        if (!databases) {
            throw new Error(`EXALMAR no configurado`);
        }
        const connectionPromises = Object.keys(databases).map(async (dbKey) => {
            try {
                const connection = await this.getConnection('EXALMAR', dbKey);
                exalmarConnections.set(dbKey, connection);
            }
            catch (error) {
                this.logger.warn(`No se pudo conectar a EXALMAR:${dbKey}`, error);
            }
        });
        await Promise.allSettled(connectionPromises);
        return exalmarConnections;
    }
    getDatabaseName(embarcacionCode, dbKey) {
        return this.exalmarDatabases[embarcacionCode]?.[dbKey] || null;
    }
    getBaseConfig() {
        return {
            host: this.configService.get('EXALMAR_DB_HOST', '208.109.188.8'),
            port: this.configService.get('EXALMAR_DB_PORT', 3306),
            username: this.configService.get('EXALMAR_DB_USER', 'perupcs_pcbarcoscontrolssac'),
            password: this.configService.get('EXALMAR_DB_PASSWORD', 'pcbarcossaccontrols123*'),
            dialect: 'mysql',
        };
    }
    getAvailableEmbarcaciones() {
        return Object.keys(this.exalmarDatabases);
    }
    getAvailableDatabases() {
        return Object.keys(this.exalmarDatabases.EXALMAR || {});
    }
    async onModuleDestroy() {
        const closePromises = Array.from(this.connections.values()).map((connection) => connection.close());
        await Promise.allSettled(closePromises);
        this.connections.clear();
        this.logger.log('🔒 Todas las conexiones EXALMAR cerradas');
    }
    async forceCloseAllConnections() {
        this.logger.log(`🔒 Forzando cierre de ${this.connections.size} conexiones EXALMAR`);
        const closePromises = Array.from(this.connections.entries()).map(async ([key, connection]) => {
            try {
                await connection.close();
                this.connections.delete(key);
                this.logger.debug(`🔒 Conexión EXALMAR ${key} cerrada forzadamente`);
            }
            catch (error) {
                this.logger.warn(`Error cerrando conexión EXALMAR ${key}:`, error);
            }
        });
        await Promise.allSettled(closePromises);
        this.connections.clear();
        this.logger.log('🔒 Todas las conexiones EXALMAR cerradas forzadamente');
    }
    getConnectionStats() {
        const activeConnections = [];
        for (const [key, connection] of this.connections.entries()) {
            activeConnections.push({
                database: key,
                status: 'active',
            });
        }
        return {
            company: 'EXALMAR',
            totalConnectionsCreated: this.connections.size,
            currentlyActiveConnections: activeConnections.length,
            activeConnections,
        };
    }
    async healthCheck() {
        const health = {};
        for (const [key, connection] of this.connections) {
            try {
                await connection.authenticate();
                health[key] = true;
            }
            catch (error) {
                health[key] = false;
                this.logger.warn(`Conexión EXALMAR ${key} no saludable:`, error);
            }
        }
        return health;
    }
};
exports.ExalmarDatabaseService = ExalmarDatabaseService;
exports.ExalmarDatabaseService = ExalmarDatabaseService = ExalmarDatabaseService_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], ExalmarDatabaseService);
//# sourceMappingURL=exalmar-database.service.js.map