"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UrlAuthMiddleware = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
let UrlAuthMiddleware = class UrlAuthMiddleware {
    configService;
    constructor(configService) {
        this.configService = configService;
    }
    use(req, res, next) {
        const originalUrl = req.originalUrl || req.url;
        if (req.urlAuthAuthorized) {
            return next();
        }
        const rutasPublicas = [
            '/exalmar/health',
            '/exalmar/embarcaciones',
            '/exalmar/sistemas',
            '/exalmar/bases-datos',
        ];
        if (rutasPublicas.includes(originalUrl)) {
            return next();
        }
        const authPattern = /^\/user=([^&]+)&password=([^\/]+)(?:\/(.*))?$/;
        const match = originalUrl.match(authPattern);
        if (!match) {
            if (!originalUrl.startsWith('/exalmar')) {
                return next();
            }
            throw new common_1.UnauthorizedException('Credenciales requeridas: /user=username&password=password/ruta');
        }
        const [, username, password, trailing] = match;
        const expectedUsername = this.configService.get('URL_AUTH_USER') ||
            this.configService.get('BASIC_AUTH_USER') ||
            'exalmar_client';
        const expectedPassword = this.configService.get('URL_AUTH_PASSWORD') ||
            this.configService.get('BASIC_AUTH_PASSWORD') ||
            'exalmar_client_2024';
        if (username !== expectedUsername || password !== expectedPassword) {
            throw new common_1.UnauthorizedException('Credenciales inválidas');
        }
        req.urlAuthAuthorized = true;
        let cleanUrl = trailing ? `/${trailing}` : '/exalmar';
        if (!cleanUrl.startsWith('/'))
            cleanUrl = '/' + cleanUrl;
        req.url = cleanUrl;
        req.originalUrl = cleanUrl;
        next();
    }
};
exports.UrlAuthMiddleware = UrlAuthMiddleware;
exports.UrlAuthMiddleware = UrlAuthMiddleware = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], UrlAuthMiddleware);
//# sourceMappingURL=url-auth.middleware.js.map