"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var ProxyService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProxyService = void 0;
const common_1 = require("@nestjs/common");
const axios_1 = require("@nestjs/axios");
const config_1 = require("@nestjs/config");
let ProxyService = ProxyService_1 = class ProxyService {
    httpService;
    configService;
    logger = new common_1.Logger(ProxyService_1.name);
    services;
    constructor(httpService, configService) {
        this.httpService = httpService;
        this.configService = configService;
        this.services = {
            auth: {
                url: this.configService.get('AUTH_SERVICE_URL', 'http://localhost:3001'),
                routes: ['/auth', '/usuario', '/roles', '/sistemas', '/permisos'],
                credentials: null,
            },
            tasa: {
                url: this.configService.get('TASA_SERVICE_URL', 'http://localhost:3002'),
                routes: ['/tasa'],
                credentials: {
                    user: this.configService.get('TASA_SERVICE_USER'),
                    password: this.configService.get('TASA_SERVICE_PASSWORD'),
                },
            },
            exalmar: {
                url: this.configService.get('EXALMAR_SERVICE_URL', 'http://localhost:3003'),
                routes: ['/exalmar'],
                credentials: {
                    user: this.configService.get('EXALMAR_SERVICE_USER'),
                    password: this.configService.get('EXALMAR_SERVICE_PASSWORD'),
                },
            },
            austral: {
                url: this.configService.get('AUSTRAL_SERVICE_URL', 'http://localhost:3004'),
                routes: ['/austral'],
                credentials: {
                    user: this.configService.get('AUSTRAL_SERVICE_USER'),
                    password: this.configService.get('AUSTRAL_SERVICE_PASSWORD'),
                },
            },
            centinela: {
                url: this.configService.get('CENTINELA_SERVICE_URL', 'http://localhost:3005'),
                routes: ['/centinela'],
                credentials: {
                    user: this.configService.get('CENTINELA_SERVICE_USER'),
                    password: this.configService.get('CENTINELA_SERVICE_PASSWORD'),
                },
            },
            diamante: {
                url: this.configService.get('DIAMANTE_SERVICE_URL', 'http://localhost:3006'),
                routes: ['/diamante'],
                credentials: {
                    user: this.configService.get('DIAMANTE_SERVICE_USER'),
                    password: this.configService.get('DIAMANTE_SERVICE_PASSWORD'),
                },
            },
        };
    }
    getTargetService(path) {
        for (const [serviceName, config] of Object.entries(this.services)) {
            const serviceConfig = config;
            if (serviceConfig.routes.some((route) => path.startsWith(route))) {
                return {
                    url: serviceConfig.url,
                    serviceName,
                    credentials: serviceConfig.credentials,
                };
            }
        }
        return null;
    }
    proxyGet(targetUrl, path, headers, credentials) {
        const requestHeaders = this.sanitizeHeaders(headers);
        let fullUrl;
        const isTasa = path.startsWith('/tasa');
        const isExalmar = path.startsWith('/exalmar');
        if ((isTasa || isExalmar) && credentials && credentials.user && credentials.password) {
            const credentialsUrl = `/user=${encodeURIComponent(credentials.user)}&password=${encodeURIComponent(credentials.password)}`;
            fullUrl = `${targetUrl}${credentialsUrl}${path}`;
            this.logger.log(`Proxying GET with URL credentials to: ${fullUrl}`);
        }
        else {
            fullUrl = `${targetUrl}${path}`;
            if (credentials && credentials.user && credentials.password) {
                const auth = Buffer.from(`${credentials.user}:${credentials.password}`).toString('base64');
                requestHeaders['Authorization'] = `Basic ${auth}`;
                this.logger.log(`Adding basic auth for service`);
            }
            this.logger.log(`Proxying GET request to: ${fullUrl}`);
        }
        return this.httpService.get(fullUrl, {
            headers: requestHeaders,
        });
    }
    proxyPost(targetUrl, path, body, headers, credentials) {
        const requestHeaders = this.sanitizeHeaders(headers);
        let fullUrl;
        const isTasaPost = path.startsWith('/tasa');
        const isExalmarPost = path.startsWith('/exalmar');
        if ((isTasaPost || isExalmarPost) && credentials && credentials.user && credentials.password) {
            const credentialsUrl = `/user=${encodeURIComponent(credentials.user)}&password=${encodeURIComponent(credentials.password)}`;
            fullUrl = `${targetUrl}${credentialsUrl}${path}`;
            this.logger.log(`Proxying POST with URL credentials to: ${fullUrl}`);
        }
        else {
            fullUrl = `${targetUrl}${path}`;
            if (credentials && credentials.user && credentials.password) {
                const auth = Buffer.from(`${credentials.user}:${credentials.password}`).toString('base64');
                requestHeaders['Authorization'] = `Basic ${auth}`;
                this.logger.log(`Adding basic auth for service`);
            }
            this.logger.log(`Proxying POST request to: ${fullUrl}`);
        }
        return this.httpService.post(fullUrl, body, {
            headers: requestHeaders,
        });
    }
    proxyPut(targetUrl, path, body, headers, credentials) {
        const requestHeaders = this.sanitizeHeaders(headers);
        let fullUrl;
        const isTasaPut = path.startsWith('/tasa');
        const isExalmarPut = path.startsWith('/exalmar');
        if ((isTasaPut || isExalmarPut) && credentials && credentials.user && credentials.password) {
            const credentialsUrl = `/user=${encodeURIComponent(credentials.user)}&password=${encodeURIComponent(credentials.password)}`;
            fullUrl = `${targetUrl}${credentialsUrl}${path}`;
            this.logger.log(`Proxying PUT with URL credentials to: ${fullUrl}`);
        }
        else {
            fullUrl = `${targetUrl}${path}`;
            if (credentials && credentials.user && credentials.password) {
                const auth = Buffer.from(`${credentials.user}:${credentials.password}`).toString('base64');
                requestHeaders['Authorization'] = `Basic ${auth}`;
                this.logger.log(`Adding basic auth for service`);
            }
            this.logger.log(`Proxying PUT request to: ${fullUrl}`);
        }
        return this.httpService.put(fullUrl, body, {
            headers: requestHeaders,
        });
    }
    proxyDelete(targetUrl, path, headers, credentials) {
        const requestHeaders = this.sanitizeHeaders(headers);
        let fullUrl;
        const isTasaDelete = path.startsWith('/tasa');
        const isExalmarDelete = path.startsWith('/exalmar');
        if ((isTasaDelete || isExalmarDelete) && credentials && credentials.user && credentials.password) {
            const credentialsUrl = `/user=${encodeURIComponent(credentials.user)}&password=${encodeURIComponent(credentials.password)}`;
            fullUrl = `${targetUrl}${credentialsUrl}${path}`;
            this.logger.log(`Proxying DELETE with URL credentials to: ${fullUrl}`);
        }
        else {
            fullUrl = `${targetUrl}${path}`;
            if (credentials && credentials.user && credentials.password) {
                const auth = Buffer.from(`${credentials.user}:${credentials.password}`).toString('base64');
                requestHeaders['Authorization'] = `Basic ${auth}`;
                this.logger.log(`Adding basic auth for service`);
            }
            this.logger.log(`Proxying DELETE request to: ${fullUrl}`);
        }
        return this.httpService.delete(fullUrl, {
            headers: requestHeaders,
        });
    }
    sanitizeHeaders(headers) {
        const newHeaders = { ...headers };
        delete newHeaders['host'];
        delete newHeaders['content-length'];
        return newHeaders;
    }
};
exports.ProxyService = ProxyService;
exports.ProxyService = ProxyService = ProxyService_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [axios_1.HttpService,
        config_1.ConfigService])
], ProxyService);
//# sourceMappingURL=proxy.service.js.map