"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TasaService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TasaService = void 0;
const common_1 = require("@nestjs/common");
const database_service_1 = require("./database/database.service");
const cache_service_1 = require("./services/cache.service");
const sistema_config_service_1 = require("./services/sistema-config.service");
const query_orchestrator_service_1 = require("./services/query-orchestrator.service");
const result_aggregator_service_1 = require("./services/result-aggregator.service");
let TasaService = TasaService_1 = class TasaService {
    databaseService;
    cacheService;
    sistemaConfigService;
    queryOrchestratorService;
    resultAggregatorService;
    logger = new common_1.Logger(TasaService_1.name);
    constructor(databaseService, cacheService, sistemaConfigService, queryOrchestratorService, resultAggregatorService) {
        this.databaseService = databaseService;
        this.cacheService = cacheService;
        this.sistemaConfigService = sistemaConfigService;
        this.queryOrchestratorService = queryOrchestratorService;
        this.resultAggregatorService = resultAggregatorService;
    }
    async consultarRegistros(dto) {
        try {
            this.logger.log(`Iniciando consulta TASA: ${JSON.stringify(dto)}`);
            const cacheKey = this.cacheService.generateCacheKey(dto);
            const cachedResult = this.cacheService.getCachedData(cacheKey);
            if (cachedResult) {
                return cachedResult;
            }
            let resultado;
            if (dto.sistema && this.sistemaConfigService.existeSistema(dto.sistema)) {
                resultado = await this.consultarSistemaEspecifico(dto);
            }
            else {
                resultado = await this.consultarTodosLosSistemas(dto);
            }
            await this.databaseService.forceCloseAllConnections();
            this.cacheService.setCachedData(cacheKey, resultado);
            return resultado;
        }
        catch (error) {
            this.logger.error(`Error en consulta TASA: ${error.message}`, error.stack);
            await this.databaseService.forceCloseAllConnections();
            throw new common_1.InternalServerErrorException('Error al consultar registros TASA');
        }
    }
    async consultarSistemaEspecifico(dto) {
        if (!dto.sistema) {
            throw new common_1.BadRequestException('Sistema es requerido para consulta específica');
        }
        if (!this.sistemaConfigService.existeSistema(dto.sistema)) {
            throw new common_1.BadRequestException(`Sistema ${dto.sistema} no encontrado`);
        }
        const resultados = await this.queryOrchestratorService.ejecutarConsultaSistemaEspecifico(dto);
        const agrupado = this.resultAggregatorService.agruparPorEmbarcacion(resultados);
        return this.resultAggregatorService.aplicarFiltroBombas(agrupado, dto.sistema, dto.limit);
    }
    async consultarTodosLosSistemas(dto) {
        const resultados = await this.queryOrchestratorService.ejecutarConsultaTodosLosSistemas(dto);
        if (dto.dbKey && dto.limit && dto.limit > 1) {
            return this.resultAggregatorService.agruparPorEmbarcacionConLimitePorTabla(resultados, dto.limit);
        }
        const agrupado = this.resultAggregatorService.agruparPorEmbarcacion(resultados);
        if (!dto.dbKey && dto.limit && dto.limit > 1) {
            return this.resultAggregatorService.aplicarLimiteGeneral(agrupado, dto.limit);
        }
        return agrupado;
    }
    async healthCheck() {
        const basesDatos = this.getBasesDatosDisponibles('TASA');
        const conexiones = {};
        for (const dbKey of basesDatos) {
            try {
                const sequelize = await this.databaseService.getConnection('TASA', dbKey);
                await sequelize.authenticate();
                conexiones[dbKey] = true;
            }
            catch (error) {
                this.logger.error(`Error conectando a ${dbKey}: ${error.message}`);
                conexiones[dbKey] = false;
            }
        }
        return {
            status: Object.values(conexiones).every((status) => status)
                ? 'healthy'
                : 'degraded',
            timestamp: new Date().toISOString(),
            connections: conexiones,
            totalDatabases: basesDatos.length,
            healthyDatabases: Object.values(conexiones).filter((status) => status)
                .length,
        };
    }
    getEmpresasDisponibles() {
        return ['TASA'];
    }
    getBasesDatosDisponibles(empresa) {
        if (empresa.toUpperCase() !== 'TASA') {
            throw new common_1.BadRequestException('Empresa no soportada');
        }
        return this.databaseService.getAvailableDatabases('TASA');
    }
};
exports.TasaService = TasaService;
exports.TasaService = TasaService = TasaService_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [database_service_1.DatabaseService,
        cache_service_1.CacheService,
        sistema_config_service_1.SistemaConfigService,
        query_orchestrator_service_1.QueryOrchestratorService,
        result_aggregator_service_1.ResultAggregatorService])
], TasaService);
//# sourceMappingURL=tasa.service.js.map