import { DatabaseService } from './database/database.service';
import { CacheService } from './services/cache.service';
import { SistemaConfigService } from './services/sistema-config.service';
import { QueryOrchestratorService } from './services/query-orchestrator.service';
import { ResultAggregatorService } from './services/result-aggregator.service';
import { ConsultaGeneralDto } from './dto/consulta-tasa.dto';
import { ResultadoConsulta, HealthCheckResult } from './interfaces/tasa.interface';
export declare class TasaService {
    private readonly databaseService;
    private readonly cacheService;
    private readonly sistemaConfigService;
    private readonly queryOrchestratorService;
    private readonly resultAggregatorService;
    private readonly logger;
    constructor(databaseService: DatabaseService, cacheService: CacheService, sistemaConfigService: SistemaConfigService, queryOrchestratorService: QueryOrchestratorService, resultAggregatorService: ResultAggregatorService);
    consultarRegistros(dto: ConsultaGeneralDto): Promise<ResultadoConsulta>;
    private consultarSistemaEspecifico;
    private consultarTodosLosSistemas;
    healthCheck(): Promise<HealthCheckResult>;
    getEmpresasDisponibles(): string[];
    getBasesDatosDisponibles(empresa: string): string[];
}
