"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var TasaController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TasaController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const tasa_service_1 = require("./tasa.service");
const consulta_tasa_dto_1 = require("./dto/consulta-tasa.dto");
const database_service_1 = require("./database/database.service");
let TasaController = TasaController_1 = class TasaController {
    tasaService;
    databaseService;
    logger = new common_1.Logger(TasaController_1.name);
    constructor(tasaService, databaseService) {
        this.tasaService = tasaService;
        this.databaseService = databaseService;
    }
    async healthCheck() {
        this.logger.log('Ejecutando health check');
        return await this.tasaService.healthCheck();
    }
    getEmpresasDisponibles() {
        this.logger.log('Obteniendo empresas disponibles');
        return this.tasaService.getEmpresasDisponibles();
    }
    getBasesDatosDisponibles() {
        this.logger.log('Obteniendo bases de datos disponibles para TASA');
        return this.tasaService.getBasesDatosDisponibles('TASA');
    }
    getConnectionStats() {
        this.logger.log('📊 Obteniendo estadísticas de conexiones');
        return this.databaseService.getConnectionStats();
    }
    async consultarRegistros(dto) {
        this.logger.log(`Consultando registros con parámetros: ${JSON.stringify(dto)}`);
        try {
            const resultado = await this.tasaService.consultarRegistros(dto);
            const totalRegistros = Object.values(resultado).reduce((total, registros) => total + registros.length, 0);
            this.logger.log(`Consulta completada: ${totalRegistros} registros en ${Object.keys(resultado).length} tablas`);
            return resultado;
        }
        catch (error) {
            this.logger.error('Error en consulta:', error);
            throw error;
        }
    }
    async ruta1_ultimoRegistroGeneral() {
        this.logger.log('Ruta 1: Obteniendo último registro general');
        return await this.tasaService.consultarRegistros({ limit: 1 });
    }
    async ruta3_ultimoRegistroSistema(sistema) {
        this.logger.log(`Ruta 3: Obteniendo último registro del sistema ${sistema}`);
        return await this.tasaService.consultarRegistros({
            sistema: sistema.toLowerCase(),
            limit: 1,
        });
    }
    async ruta4_registrosSistema(sistema, limit) {
        const limitNum = parseInt(limit);
        if (isNaN(limitNum) || limitNum <= 0 || limitNum > 100) {
            throw new common_1.HttpException('El límite debe ser un número entre 1 y 100', common_1.HttpStatus.BAD_REQUEST);
        }
        this.logger.log(`Ruta 4: Obteniendo últimos ${limit} registros del sistema ${sistema}`);
        return await this.tasaService.consultarRegistros({
            sistema: sistema.toLowerCase(),
            limit: limitNum,
        });
    }
    async ruta5_ultimoRegistroBaseDatos(embarcacion) {
        if (!embarcacion.toUpperCase().startsWith('TASA')) {
            throw new common_1.HttpException(`EP '${embarcacion}' no está configurada`, common_1.HttpStatus.BAD_REQUEST);
        }
        this.logger.log(`Ruta 5: Obteniendo último registro de la EP ${embarcacion}`);
        return await this.tasaService.consultarRegistros({
            dbKey: embarcacion.toUpperCase(),
            limit: 1,
        });
    }
    async ruta6_registrosBaseDatos(embarcacion, limit) {
        const limitNum = parseInt(limit);
        if (isNaN(limitNum) || limitNum <= 0 || limitNum > 100) {
            throw new common_1.HttpException('El límite debe ser un número entre 1 y 100', common_1.HttpStatus.BAD_REQUEST);
        }
        if (!embarcacion.toUpperCase().startsWith('TASA')) {
            throw new common_1.HttpException(`EP '${embarcacion}' no está configurada`, common_1.HttpStatus.BAD_REQUEST);
        }
        this.logger.log(`Ruta 6: Obteniendo últimos ${limit} registros de la EP ${embarcacion}`);
        return await this.tasaService.consultarRegistros({
            dbKey: embarcacion.toUpperCase(),
            limit: limitNum,
        });
    }
    async ruta7_consultaCompletaBaseDatos(embarcacion, fechaInicio, fechaFin, sistema) {
        if (!this.isValidDate(fechaInicio) || !this.isValidDate(fechaFin)) {
            throw new common_1.HttpException('Fechas inválidas. Deben tener formato YYYY-MM-DD', common_1.HttpStatus.BAD_REQUEST);
        }
        this.validateDateRange(fechaInicio, fechaFin, 10);
        if (!embarcacion.toUpperCase().startsWith('TASA')) {
            throw new common_1.HttpException(`EP '${embarcacion}' no está configurada`, common_1.HttpStatus.BAD_REQUEST);
        }
        this.logger.log(`Ruta 7: Consultando ${sistema} en ${embarcacion} desde ${fechaInicio} hasta ${fechaFin}`);
        return await this.tasaService.consultarRegistros({
            dbKey: embarcacion.toUpperCase(),
            desde: fechaInicio,
            hasta: `${fechaFin} 23:59:59`,
            sistema: sistema.toLowerCase(),
        });
    }
    async ruta8_consultaPorFechas(fechaInicio, fechaFin) {
        if (!this.isValidDate(fechaInicio) || !this.isValidDate(fechaFin)) {
            throw new common_1.HttpException('Fechas inválidas. Deben tener formato YYYY-MM-DD', common_1.HttpStatus.BAD_REQUEST);
        }
        this.validateDateRange(fechaInicio, fechaFin, 5);
        this.logger.log(`Ruta 8: Consultando desde ${fechaInicio} hasta ${fechaFin} en todas las EPs`);
        return await this.tasaService.consultarRegistros({
            desde: fechaInicio,
            hasta: `${fechaFin} 23:59:59`,
        });
    }
    async ruta9_consultaPorFechasSistema(fechaInicio, fechaFin, sistema) {
        if (!this.isValidDate(fechaInicio) || !this.isValidDate(fechaFin)) {
            throw new common_1.HttpException('Fechas inválidas. Deben tener formato YYYY-MM-DD', common_1.HttpStatus.BAD_REQUEST);
        }
        this.validateDateRange(fechaInicio, fechaFin, 10);
        this.logger.log(`Ruta 9: Consultando ${sistema} desde ${fechaInicio} hasta ${fechaFin} en todas las EPs`);
        return await this.tasaService.consultarRegistros({
            desde: fechaInicio,
            hasta: `${fechaFin} 23:59:59`,
            sistema: sistema.toLowerCase(),
        });
    }
    async ruta2_registrosGenerales(limit) {
        const limitNum = parseInt(limit);
        if (isNaN(limitNum) || limitNum <= 0 || limitNum > 100) {
            throw new common_1.HttpException('El límite debe ser un número entre 1 y 100', common_1.HttpStatus.BAD_REQUEST);
        }
        this.logger.log(`Ruta 2: Obteniendo últimos ${limit} registros generales`);
        return await this.tasaService.consultarRegistros({ limit: limitNum });
    }
    isValidDate(dateString) {
        const regex = /^\d{4}-\d{2}-\d{2}$/;
        if (!regex.test(dateString))
            return false;
        const date = new Date(dateString);
        return !isNaN(date.getTime());
    }
    validateDateRange(fechaInicio, fechaFin, maxDays) {
        const startDate = new Date(fechaInicio);
        const endDate = new Date(fechaFin);
        if (startDate > endDate) {
            throw new common_1.HttpException('La fecha de inicio no puede ser posterior a la fecha de fin', common_1.HttpStatus.BAD_REQUEST);
        }
        const diffTime = Math.abs(endDate.getTime() - startDate.getTime());
        const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
        if (diffDays > maxDays) {
            throw new common_1.HttpException(`El rango de fechas no puede exceder ${maxDays} días. Rango actual: ${diffDays} días`, common_1.HttpStatus.BAD_REQUEST);
        }
    }
};
exports.TasaController = TasaController;
__decorate([
    (0, common_1.Get)('health'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiExcludeEndpoint)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TasaController.prototype, "healthCheck", null);
__decorate([
    (0, common_1.Get)('empresas'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiExcludeEndpoint)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Array)
], TasaController.prototype, "getEmpresasDisponibles", null);
__decorate([
    (0, common_1.Get)('bases-datos'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiExcludeEndpoint)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Array)
], TasaController.prototype, "getBasesDatosDisponibles", null);
__decorate([
    (0, common_1.Get)('conexiones/stats'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiExcludeEndpoint)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TasaController.prototype, "getConnectionStats", null);
__decorate([
    (0, common_1.Get)('consultar'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiExcludeEndpoint)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [consulta_tasa_dto_1.ConsultaGeneralDto]),
    __metadata("design:returntype", Promise)
], TasaController.prototype, "consultarRegistros", null);
__decorate([
    (0, common_1.Get)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiOperation)({
        summary: '1. Último registro general',
        description: 'Obtiene el último registro de todos los sistemas en todas las EPs',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Último registro obtenido exitosamente',
        schema: {
            type: 'object',
            additionalProperties: {
                type: 'array',
                items: { type: 'object' },
            },
        },
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TasaController.prototype, "ruta1_ultimoRegistroGeneral", null);
__decorate([
    (0, common_1.Get)('sistema/:sistema'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiOperation)({
        summary: '3. Último registro de sistema específico',
        description: 'Obtiene el último registro de un sistema específico (slave1, slave2, bomba, etc.)',
    }),
    (0, swagger_1.ApiParam)({
        name: 'sistema',
        description: 'Sistema específico a consultar',
        example: 'slave1',
        enum: ['slave1', 'slave2', 'bomba', 'pesca', 'planta', 'bnwas'],
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Último registro del sistema obtenido exitosamente',
    }),
    __param(0, (0, common_1.Param)('sistema')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], TasaController.prototype, "ruta3_ultimoRegistroSistema", null);
__decorate([
    (0, common_1.Get)('sistema/:sistema/:limit'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiOperation)({
        summary: '4. N registros de sistema específico',
        description: 'Obtiene los últimos N registros de un sistema específico',
    }),
    (0, swagger_1.ApiParam)({
        name: 'sistema',
        description: 'Sistema específico a consultar',
        example: 'slave1',
    }),
    (0, swagger_1.ApiParam)({
        name: 'limit',
        description: 'Número de registros a obtener (1-100)',
        example: '10',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Registros del sistema obtenidos exitosamente',
    }),
    __param(0, (0, common_1.Param)('sistema')),
    __param(1, (0, common_1.Param)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], TasaController.prototype, "ruta4_registrosSistema", null);
__decorate([
    (0, common_1.Get)('embarcacion/:embarcacion'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiOperation)({
        summary: '5. Último registro de EP específica',
        description: 'Obtiene el último registro de una EP específica (ej: TASA17)',
    }),
    (0, swagger_1.ApiParam)({
        name: 'embarcacion',
        description: 'EP específica',
        example: 'TASA17',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Último registro de la EP obtenido exitosamente',
    }),
    __param(0, (0, common_1.Param)('embarcacion')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], TasaController.prototype, "ruta5_ultimoRegistroBaseDatos", null);
__decorate([
    (0, common_1.Get)('embarcacion/:embarcacion/:limit'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiOperation)({
        summary: '6. N registros de EP específica',
        description: 'Obtiene los últimos N registros de una EP específica',
    }),
    (0, swagger_1.ApiParam)({
        name: 'embarcacion',
        description: 'EP específica',
        example: 'TASA17',
    }),
    (0, swagger_1.ApiParam)({
        name: 'limit',
        description: 'Número de registros a obtener (1-100)',
        example: '10',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Registros de la base de datos obtenidos exitosamente',
    }),
    __param(0, (0, common_1.Param)('embarcacion')),
    __param(1, (0, common_1.Param)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], TasaController.prototype, "ruta6_registrosBaseDatos", null);
__decorate([
    (0, common_1.Get)('embarcacion/:embarcacion/:fechaInicio/:fechaFin/:sistema'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiOperation)({
        summary: '7. Consulta completa en EP específica',
        description: 'Consulta registros de un sistema específico en un rango de fechas en una EP específica',
    }),
    (0, swagger_1.ApiParam)({
        name: 'embarcacion',
        description: 'Embarcación específica',
        example: 'TASA17',
    }),
    (0, swagger_1.ApiParam)({
        name: 'fechaInicio',
        description: 'Fecha de inicio (YYYY-MM-DD)',
        example: '2025-01-01',
    }),
    (0, swagger_1.ApiParam)({
        name: 'fechaFin',
        description: 'Fecha de fin (YYYY-MM-DD)',
        example: '2025-01-31',
    }),
    (0, swagger_1.ApiParam)({
        name: 'sistema',
        description: 'Sistema específico',
        example: 'slave1',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Registros filtrados obtenidos exitosamente',
    }),
    __param(0, (0, common_1.Param)('embarcacion')),
    __param(1, (0, common_1.Param)('fechaInicio')),
    __param(2, (0, common_1.Param)('fechaFin')),
    __param(3, (0, common_1.Param)('sistema')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String, String]),
    __metadata("design:returntype", Promise)
], TasaController.prototype, "ruta7_consultaCompletaBaseDatos", null);
__decorate([
    (0, common_1.Get)('fechas/:fechaInicio/:fechaFin'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiOperation)({
        summary: '8. Consulta por fechas en todas las EPs',
        description: 'Consulta registros en un rango de fechas en todas las EPs disponibles',
    }),
    (0, swagger_1.ApiParam)({
        name: 'fechaInicio',
        description: 'Fecha de inicio (YYYY-MM-DD)',
        example: '2025-01-01',
    }),
    (0, swagger_1.ApiParam)({
        name: 'fechaFin',
        description: 'Fecha de fin (YYYY-MM-DD)',
        example: '2025-01-31',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Registros en rango de fechas obtenidos exitosamente',
    }),
    __param(0, (0, common_1.Param)('fechaInicio')),
    __param(1, (0, common_1.Param)('fechaFin')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], TasaController.prototype, "ruta8_consultaPorFechas", null);
__decorate([
    (0, common_1.Get)('fechas/:fechaInicio/:fechaFin/:sistema'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiOperation)({
        summary: '9. Consulta por fechas y sistema en todas las EPs',
        description: 'Consulta registros de un sistema específico en un rango de fechas en todas las EPs',
    }),
    (0, swagger_1.ApiParam)({
        name: 'fechaInicio',
        description: 'Fecha de inicio (YYYY-MM-DD)',
        example: '2025-01-01',
    }),
    (0, swagger_1.ApiParam)({
        name: 'fechaFin',
        description: 'Fecha de fin (YYYY-MM-DD)',
        example: '2025-01-31',
    }),
    (0, swagger_1.ApiParam)({
        name: 'sistema',
        description: 'Sistema específico',
        example: 'slave1',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Registros filtrados por fechas y sistema obtenidos exitosamente',
    }),
    __param(0, (0, common_1.Param)('fechaInicio')),
    __param(1, (0, common_1.Param)('fechaFin')),
    __param(2, (0, common_1.Param)('sistema')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String]),
    __metadata("design:returntype", Promise)
], TasaController.prototype, "ruta9_consultaPorFechasSistema", null);
__decorate([
    (0, common_1.Get)(':limit'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    (0, swagger_1.ApiOperation)({
        summary: '2. N registros generales',
        description: 'Obtiene los últimos N registros de todos los sistemas en todas las EPs',
    }),
    (0, swagger_1.ApiParam)({
        name: 'limit',
        description: 'Número de registros a obtener (1-100)',
        example: '10',
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'Registros generales obtenidos exitosamente',
    }),
    __param(0, (0, common_1.Param)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], TasaController.prototype, "ruta2_registrosGenerales", null);
exports.TasaController = TasaController = TasaController_1 = __decorate([
    (0, swagger_1.ApiTags)('TASA - Consultas de Barcos'),
    (0, common_1.Controller)('tasa'),
    __metadata("design:paramtypes", [tasa_service_1.TasaService,
        database_service_1.DatabaseService])
], TasaController);
//# sourceMappingURL=tasa.controller.js.map