"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SistemaConfigService = void 0;
const common_1 = require("@nestjs/common");
let SistemaConfigService = class SistemaConfigService {
    sistemaTablasMap = {
        slave1: ['slave1'],
        slave2: ['slave2'],
        slave3: ['auxiliar1', 'auxiliar3', 'slave3'],
        slave4: ['auxiliar2', 'slave4'],
        slave5: ['slave5'],
        slave6: ['slave6'],
        bomba: [
            'bomba1',
            'bomba2',
            'bomba3',
            'bomba4',
            'bomba5',
            'millasachique',
            'bomba10',
        ],
        bnwas: ['bnwas'],
        pesca: ['calas_slave1'],
        comp1: ['est_comp1_slave1'],
        comp2: ['est_comp2_slave1'],
        planta: ['est_planta_slave1'],
        restfull: ['reportesmelecto'],
    };
    getSistemaTablaMap() {
        return this.sistemaTablasMap;
    }
    getTablasPorSistema(sistema) {
        return this.sistemaTablasMap[sistema];
    }
    existeSistema(sistema) {
        return sistema in this.sistemaTablasMap;
    }
    getSistemasDisponibles() {
        return Object.keys(this.sistemaTablasMap);
    }
    getTodasLasTablas() {
        return Array.from(new Set(Object.values(this.sistemaTablasMap).flat()));
    }
    esSistemaBombas(sistema) {
        return sistema === 'bomba' || sistema === 'bnwas';
    }
};
exports.SistemaConfigService = SistemaConfigService;
exports.SistemaConfigService = SistemaConfigService = __decorate([
    (0, common_1.Injectable)()
], SistemaConfigService);
//# sourceMappingURL=sistema-config.service.js.map