import { SistemaConfigService } from './sistema-config.service';
import { ResultadoConsulta } from '../interfaces/tasa.interface';
import { QueryResult } from './query-orchestrator.service';
export declare class ResultAggregatorService {
    private readonly sistemaConfigService;
    private readonly logger;
    private readonly prioridadReportes;
    constructor(sistemaConfigService: SistemaConfigService);
    agruparPorEmbarcacion(resultados: QueryResult[]): ResultadoConsulta;
    agruparPorEmbarcacionConLimitePorTabla(resultados: QueryResult[], limit: number): ResultadoConsulta;
    aplicarFiltroBombas(agrupado: ResultadoConsulta, sistema?: string, limit?: number): ResultadoConsulta;
    aplicarLimiteGeneral(agrupado: ResultadoConsulta, limit: number): ResultadoConsulta;
    private ordenarRegistrosPorReporteYFecha;
    private filtrarRegistrosBombasDuplicados;
    private consolidarRegistrosBnhas;
}
