"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var DataProcessorService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataProcessorService = void 0;
const common_1 = require("@nestjs/common");
let DataProcessorService = DataProcessorService_1 = class DataProcessorService {
    logger = new common_1.Logger(DataProcessorService_1.name);
    procesarRegistro(row, sistema, tabla, dbKey) {
        switch (sistema) {
            case 'slave1':
                return this.procesarSlave1(row, sistema, dbKey);
            case 'slave2':
                return this.procesarSlave2(row, sistema, dbKey);
            case 'slave3':
            case 'slave4':
                return this.procesarRegistroGenerico(row, sistema, dbKey);
            case 'slave5':
                return this.procesarSlave5(row, sistema, dbKey);
            case 'slave6':
                return this.procesarSlave6(row, sistema, dbKey);
            case 'bomba':
                return this.procesarBombas(row, tabla, dbKey, sistema);
            case 'bnwas':
                return this.procesarBnwas(row, dbKey);
            case 'pesca':
                return this.procesarPesca(row, sistema, dbKey);
            case 'comp1':
            case 'comp2':
                return this.procesarCompresor(row, sistema, dbKey);
            case 'planta':
                return this.procesarPlanta(row, sistema, dbKey);
            case 'restfull':
                return this.procesarRestfull(row, sistema, dbKey);
            default:
                return this.procesarRegistroGenerico(row, sistema, dbKey);
        }
    }
    procesarRegistroGenerico(row, sistema, key) {
        return {
            idmensaje: `${row.id}`,
            Reporte: sistema,
            Tabla: this.formatearNombreBarco(key),
            fecha: row.fecha,
            latitud: row.latitude,
            longitud: row.longitude,
            speed: row.speed,
            header: row.heading ?? row.header,
            canal8: row.TEMP_IN,
            canal9: row.TEMP_RET ?? null,
            canal10: row.RPM,
            canal11: row.FR_IN ?? null,
            canal12: row.FR_RET ?? null,
            canal13: row.GAL_H,
            canal14: row.TOTAL,
            canal15: row.HOROM,
            canal16: null,
            canal17: null,
            canal18: null,
            canal19: null,
            canal20: null,
            canal21: null,
            canal22: null,
            canal23: null,
            canal24: null,
            canal25: null,
            canal99: row.odometer,
        };
    }
    procesarSlave1(row, sistema, key) {
        return {
            idmensaje: `${row.id}`,
            Reporte: sistema,
            Tabla: this.formatearNombreBarco(key),
            fecha: row.fecha,
            latitud: row.latitude,
            longitud: row.longitude,
            speed: row.speed,
            header: row.heading ?? row.header,
            canal8: row.PR_BR,
            canal9: row.PR_ER,
            canal10: row.PR_CT,
            canal11: row.PP_CT,
            canal12: row.PP_BR,
            canal13: row.PP_ER,
            canal14: row.HORO_1,
            canal15: row.HORO_2,
            canal16: row.ON_OFF1,
            canal17: row.ON_OFF2,
            canal18: '0',
            canal19: '0',
            canal20: row.CHIER_IN,
            canal21: row.CHIER_OUT,
            canal22: row.CHICT_IN,
            canal23: row.CHICT_OUT,
            canal24: row.CHIBR_IN,
            canal25: row.CHIBR_OUT,
            canal99: row.odometer,
        };
    }
    procesarSlave2(row, sistema, key) {
        return {
            idmensaje: `${row.id}`,
            Reporte: sistema,
            Tabla: this.formatearNombreBarco(key),
            fecha: row.fecha,
            latitud: row.latitude,
            longitud: row.longitude,
            speed: row.speed,
            header: row.heading ?? row.header,
            canal8: row.TEMP_IN,
            canal9: row.TEMP_RET,
            canal10: row.RPM,
            canal11: row.FR_IN,
            canal12: row.FR_RET,
            canal13: row.GAL_H,
            canal14: row.TOTAL,
            canal15: row.PASO,
            canal16: null,
            canal17: null,
            canal18: null,
            canal19: null,
            canal20: null,
            canal21: null,
            canal22: null,
            canal23: null,
            canal24: null,
            canal25: null,
            canal99: row.odometer,
        };
    }
    procesarSlave5(row, sistema, key) {
        return {
            idmensaje: `${row.id}`,
            Reporte: sistema,
            Tabla: this.formatearNombreBarco(key),
            fecha: row.fecha,
            latitud: row.latitude,
            longitud: row.longitude,
            speed: row.speed,
            header: row.heading ?? row.header,
            canal8: row.TK_1,
            canal9: row.TK_2,
            canal10: row.TK_3,
            canal11: row.TK_4,
            canal12: row.TK_5,
            canal13: row.TK_6,
            canal14: row.TK_7,
            canal15: row.TK_8,
            canal16: row.TOTAL,
            canal17: null,
            canal18: null,
            canal19: null,
            canal20: null,
            canal21: null,
            canal22: null,
            canal23: null,
            canal24: null,
            canal25: null,
            canal99: row.odometer,
        };
    }
    procesarSlave6(row, sistema, key) {
        return {
            idmensaje: `${row.id}`,
            Reporte: sistema,
            Tabla: this.formatearNombreBarco(key),
            fecha: row.fecha,
            latitud: row.latitude,
            longitud: row.longitude,
            speed: row.speed,
            header: row.heading ?? row.header,
            canal8: row.HORO_MP,
            canal9: row.HORO_G1,
            canal10: row.HORO_G2,
            canal11: row.HORO_G3,
            canal12: row.HORO_G4,
            canal13: row.HORO_G5,
            canal14: row.ACEITE_1,
            canal15: row.ACEITE_2,
            canal16: row.ACEITE_3,
            canal17: null,
            canal18: null,
            canal19: null,
            canal20: null,
            canal21: null,
            canal22: null,
            canal23: null,
            canal24: null,
            canal25: null,
            canal99: row.odometer,
        };
    }
    procesarRestfull(row, sistema, key) {
        return {
            idmensaje: `${row.id}`,
            Reporte: sistema,
            Tabla: this.formatearNombreBarco(key),
            fecha: row.fecha,
            latitud: row.latitude,
            longitud: row.longitude,
            speed: row.speed,
            header: row.heading ?? row.header,
            canal8: row.parameter01,
            canal9: row.parameter02,
            canal10: row.parameter03,
            canal11: row.parameter04,
            canal12: row.parameter05,
            canal13: row.parameter06,
            canal14: row.parameter07,
            canal15: row.parameter08,
            canal16: row.parameter09,
            canal17: row.parameter10,
            canal18: row.parameter11,
            canal19: row.parameter12,
            canal20: row.parameter13,
            canal21: row.parameter14,
            canal22: row.parameter15,
            canal23: '0',
            canal24: '0',
            canal25: '0',
            canal99: row.odometer,
        };
    }
    procesarPesca(row, sistema, key) {
        return {
            idmensaje: `${row.id}`,
            Reporte: sistema,
            Tabla: this.formatearNombreBarco(key),
            fecha: row.fecha,
            latitud: row.latitude,
            longitud: row.longitude,
            speed: row.speed,
            header: row.heading ?? row.header,
            canal8: row.NUM_CALA,
            canal9: row.PESCA_4,
            canal10: row.AGUA_4,
            canal11: row.PESCA_1,
            canal12: row.AGUA_1,
            canal13: row.PESCA_3,
            canal14: row.AGUA_3,
            canal15: row.PESCA_6,
            canal16: row.AGUA_6,
            canal17: row.PESCA_5,
            canal18: row.AGUA_5,
            canal19: row.PESCA_2,
            canal20: row.AGUA_2,
            canal21: null,
            canal22: null,
            canal23: null,
            canal24: null,
            canal25: null,
            canal99: row.odometer,
        };
    }
    procesarCompresor(row, sistema, key) {
        return {
            idmensaje: `${row.id}`,
            Reporte: sistema,
            Tabla: this.formatearNombreBarco(key),
            fecha: row.fecha,
            latitud: row.latitude,
            longitud: row.longitude,
            speed: row.speed,
            header: row.heading ?? row.header,
            canal8: row.EST_COMP_1 ?? row.EST_COMP_2,
            canal9: null,
            canal10: null,
            canal11: null,
            canal12: null,
            canal13: null,
            canal14: null,
            canal15: null,
            canal16: null,
            canal17: null,
            canal18: null,
            canal19: null,
            canal20: null,
            canal21: null,
            canal22: null,
            canal23: null,
            canal24: null,
            canal25: null,
            canal99: row.odometer,
        };
    }
    procesarPlanta(row, sistema, key) {
        return {
            idmensaje: `${row.id}`,
            Reporte: sistema,
            Tabla: this.formatearNombreBarco(key),
            fecha: row.fecha,
            latitud: row.latitude,
            longitud: row.longitude,
            speed: row.speed,
            header: row.heading ?? row.header,
            canal8: row.EST_PLANTA,
            canal9: row.P_OPERA,
            canal10: null,
            canal11: null,
            canal12: null,
            canal13: null,
            canal14: null,
            canal15: null,
            canal16: null,
            canal17: null,
            canal18: null,
            canal19: null,
            canal20: null,
            canal21: null,
            canal22: null,
            canal23: null,
            canal24: null,
            canal25: null,
            canal99: row.odometer,
        };
    }
    procesarBombas(row, tabla, key, sistema) {
        if (tabla === 'bnwas') {
            const resultado = this.separarPalabraYNumero(row.nombre_bomba);
            return {
                idmensaje: `${row.id}`,
                Reporte: resultado.palabra,
                Tabla: this.formatearNombreBarco(key),
                fecha: row.fecha,
                latitud: row.latitude,
                longitud: row.longitude,
                bomba: resultado.numero,
                distancia: null,
                estado: row.estado ? String(row.estado) : null,
            };
        }
        else if (tabla === 'millasachique') {
            const fechaFormateada = this.reformatearFecha(row.fecha);
            const latitud = row.latitud
                ? Math.trunc(Number(row.latitud) * 60000)
                : null;
            const longitud = row.longitud
                ? Math.trunc(Number(row.longitud) * 60000)
                : null;
            return {
                idmensaje: `${row.id}`,
                Reporte: sistema,
                Tabla: this.formatearNombreBarco(key),
                fecha: fechaFormateada,
                latitud: latitud != null ? `${latitud}` : null,
                longitud: longitud != null ? `${longitud}` : null,
                bomba: '6',
                distancia: row.distancia_millas ?? null,
                estado: row.estado == 'APAGADO' ? '2' : '1',
            };
        }
        else {
            const resultado = this.separarPalabraYNumero(tabla);
            return {
                idmensaje: `${row.id}`,
                Reporte: resultado.palabra,
                Tabla: this.formatearNombreBarco(key),
                fecha: row.fecha,
                latitud: row.latitude,
                longitud: row.longitude,
                bomba: resultado.numero,
                distancia: row.distancia_millas ?? null,
                estado: row.estado ? String(row.estado) : null,
            };
        }
    }
    procesarBnwas(row, key) {
        const resultado = this.separarPalabraYNumero(row.nombre_bomba);
        const embarcacionNombre = this.formatearNombreBarco(key);
        const registroBase = {
            idmensaje: `${row.id}`,
            Reporte: 'bnwas',
            Tabla: embarcacionNombre,
            fecha: row.fecha,
            latitud: row.latitude,
            longitud: row.longitude,
            speed: row.speed,
            header: row.heading ?? row.header,
        };
        if (['bomba7', 'bomba8', 'bomba9'].includes(row.nombre_bomba)) {
            return {
                ...registroBase,
                embarcacion: embarcacionNombre,
                bombaachique: resultado.numero ?? null,
                bnwas_energia: row.bnwas_energia ?? null,
                bnwas_nivel: row.bnwas_nivel ?? null,
                bnwas_alarma: row.bnwas_alarma ?? null,
                bnwas_bomba: row.bnwas_bomba ?? null,
            };
        }
        return {
            ...registroBase,
            bomba: resultado.numero,
            distancia: null,
            estado: row.estado ? String(row.estado) : null,
        };
    }
    formatearNombreBarco(key) {
        return key.replace(/^TASA/i, 'Tasa ').trim();
    }
    separarPalabraYNumero(input) {
        const match = input.match(/^([a-zA-Z]+)(\d+)$/);
        if (match) {
            return {
                palabra: match[1],
                numero: match[2],
            };
        }
        return {
            palabra: input,
            numero: '',
        };
    }
    reformatearFecha(fecha) {
        if (!fecha)
            return '';
        try {
            const date = new Date(fecha);
            return date.toISOString().slice(0, 19).replace('T', ' ');
        }
        catch (error) {
            this.logger.warn(`Error formateando fecha: ${fecha}`, error);
            return String(fecha);
        }
    }
    consolidarRegistrosBnwas(registrosBnwas) {
        const registroBase = registrosBnwas[0];
        const bomba7 = registrosBnwas.find((r) => r.bombaachique === '7' || r.bnwas_energia !== null);
        const bomba8 = registrosBnwas.find((r) => r.bombaachique === '8');
        const bomba9 = registrosBnwas.find((r) => r.bombaachique === '9');
        return {
            ...registroBase,
            bomba7_energia: bomba7?.bnwas_energia ?? null,
            bomba7_nivel: bomba7?.bnwas_nivel ?? null,
            bomba7_alarma: bomba7?.bnwas_alarma ?? null,
            bomba7_bomba: bomba7?.bnwas_bomba ?? null,
            bomba8_energia: bomba8?.bnwas_energia ?? null,
            bomba8_nivel: bomba8?.bnwas_nivel ?? null,
            bomba8_alarma: bomba8?.bnwas_alarma ?? null,
            bomba8_bomba: bomba8?.bnwas_bomba ?? null,
            bomba9_energia: bomba9?.bnwas_energia ?? null,
            bomba9_nivel: bomba9?.bnwas_nivel ?? null,
            bomba9_alarma: bomba9?.bnwas_alarma ?? null,
            bomba9_bomba: bomba9?.bnwas_bomba ?? null,
        };
    }
};
exports.DataProcessorService = DataProcessorService;
exports.DataProcessorService = DataProcessorService = DataProcessorService_1 = __decorate([
    (0, common_1.Injectable)()
], DataProcessorService);
//# sourceMappingURL=data-processor.service.js.map