"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var ConcurrencyService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConcurrencyService = void 0;
const common_1 = require("@nestjs/common");
let ConcurrencyService = ConcurrencyService_1 = class ConcurrencyService {
    logger = new common_1.Logger(ConcurrencyService_1.name);
    MAX_CONCURRENT_QUERIES = 8;
    async executeWithLimitedConcurrency(tasks, concurrencyLimit = this.MAX_CONCURRENT_QUERIES) {
        const results = [];
        for (let i = 0; i < tasks.length; i += concurrencyLimit) {
            const batch = tasks.slice(i, i + concurrencyLimit);
            const batchResults = await Promise.allSettled(batch.map((task) => task()));
            batchResults.forEach((result, index) => {
                if (result.status === 'fulfilled') {
                    results.push(result.value);
                }
                else {
                    this.logger.warn(`Error en tarea ${i + index}:`, result.reason);
                }
            });
        }
        return results;
    }
    async executeTasksWithErrorHandling(tasks, concurrencyLimit = this.MAX_CONCURRENT_QUERIES) {
        const results = [];
        for (let i = 0; i < tasks.length; i += concurrencyLimit) {
            const batch = tasks.slice(i, i + concurrencyLimit);
            const batchResults = await Promise.allSettled(batch.map(async ({ id, task }) => ({ id, result: await task() })));
            batchResults.forEach((result, index) => {
                const taskId = batch[index].id;
                if (result.status === 'fulfilled') {
                    results.push({
                        id: taskId,
                        result: result.value.result,
                    });
                }
                else {
                    this.logger.warn(`Error en tarea ${taskId}:`, result.reason);
                    results.push({
                        id: taskId,
                        error: result.reason,
                    });
                }
            });
        }
        return results;
    }
    getMaxConcurrency() {
        return this.MAX_CONCURRENT_QUERIES;
    }
    setMaxConcurrency(limit) {
        if (limit > 0 && limit <= 20) {
            this.MAX_CONCURRENT_QUERIES = limit;
            this.logger.log(`Límite de concurrencia actualizado a: ${limit}`);
        }
        else {
            this.logger.warn(`Límite de concurrencia inválido: ${limit}. Debe estar entre 1 y 20.`);
        }
    }
};
exports.ConcurrencyService = ConcurrencyService;
exports.ConcurrencyService = ConcurrencyService = ConcurrencyService_1 = __decorate([
    (0, common_1.Injectable)()
], ConcurrencyService);
//# sourceMappingURL=concurrency.service.js.map