"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const common_1 = require("@nestjs/common");
const app_module_1 = require("./app.module");
const swagger_1 = require("@nestjs/swagger");
async function bootstrap() {
    const app = await core_1.NestFactory.create(app_module_1.AppModule);
    app.enableCors({
        origin: true,
        credentials: true,
    });
    app.use((req, res, next) => {
        const originalUrl = req.originalUrl || req.url;
        const rutasPublicas = [
            '/exalmar/health',
            '/exalmar/embarcaciones',
            '/exalmar/sistemas',
            '/exalmar/bases-datos',
        ];
        if (rutasPublicas.includes(originalUrl)) {
            return next();
        }
        const authPattern = /^\/user=([^&]+)&password=([^\/]+)(?:\/(.*))?$/;
        const match = originalUrl.match(authPattern);
        if (!match) {
            if (originalUrl.startsWith('/exalmar')) {
                res.status(401).json({
                    message: 'Credenciales requeridas: /user=username&password=password/ruta',
                });
                return;
            }
            return next();
        }
        const [, username, password, trailing] = match;
        const expectedUsername = process.env.URL_AUTH_USER || process.env.BASIC_AUTH_USER || 'exalmar_client';
        const expectedPassword = process.env.URL_AUTH_PASSWORD || process.env.BASIC_AUTH_PASSWORD || 'exalmar_client_2024';
        if (username !== expectedUsername || password !== expectedPassword) {
            res.status(401).json({ message: 'Credenciales inválidas' });
            return;
        }
        req.urlAuthAuthorized = true;
        let cleanUrl = trailing ? `/${trailing}` : '/exalmar';
        if (!cleanUrl.startsWith('/'))
            cleanUrl = '/' + cleanUrl;
        req.url = cleanUrl;
        req.originalUrl = cleanUrl;
        return next();
    });
    app.useGlobalPipes(new common_1.ValidationPipe({
        transform: true,
        whitelist: true,
    }));
    const config = new swagger_1.DocumentBuilder()
        .setTitle('Exalmar Service API')
        .setDescription('API para el cliente Exalmar - Gestión de datos pesqueros')
        .setVersion('1.0')
        .addBearerAuth()
        .build();
    const document = swagger_1.SwaggerModule.createDocument(app, config);
    swagger_1.SwaggerModule.setup('api/docs', app, document);
    const port = process.env.PORT || 3003;
    await app.listen(port);
    console.log(`Exalmar Service is running on port ${port}`);
    console.log(`📚 Swagger docs available at http://localhost:${port}/api/docs`);
}
bootstrap();
//# sourceMappingURL=main.js.map