export interface RegistroExalmar {
    id: string;
    reporte: string;
    tabla: string;
    fecha: string;
    latitud: string | null;
    longitud: string | null;
    speed: string | null;
    header: string | null;
    embarcacion: string;
    canal8?: string | null;
    canal9?: string | null;
    canal10?: string | null;
    canal11?: string | null;
    canal12?: string | null;
    canal13?: string | null;
    canal14?: string | null;
    canal15?: string | null;
    canal16?: string | null;
    canal17?: string | null;
    canal18?: string | null;
    canal19?: string | null;
    canal20?: string | null;
    canal21?: string | null;
    canal22?: string | null;
    canal23?: string | null;
    canal24?: string | null;
    canal25?: string | null;
    canal99?: string | null;
}
export interface RegistroReportesmelecto {
    id: string;
    Reporte: string;
    Tabla: string;
    fecha: string;
    latitud: string | null;
    longitud: string | null;
    embarcacion: string;
    [key: string]: any;
}
export interface ConsultaExalmarOptions {
    limit?: number;
    sistema?: string;
    desde?: string;
    hasta?: string;
    embarcacion?: string;
}
export interface SistemaTablaExalmarMap {
    [sistema: string]: string[];
}
export interface ResultadoConsultaExalmar {
    [embarcacion: string]: (RegistroExalmar | RegistroReportesmelecto)[];
}
export interface HealthCheckExalmarResult {
    status: 'healthy' | 'degraded' | 'unhealthy';
    connections: {
        [key: string]: boolean;
    };
    timestamp: string;
    totalDatabases: number;
    healthyDatabases: number;
}
export interface EmbarcacionConfig {
    nombre: string;
    codigoBD: string;
    tablas: string[];
}
