import { ExalmarDatabaseService } from './database/exalmar-database.service';
import { ConsultaGeneralExalmarDto } from './dto/consulta-exalmar.dto';
import { ResultadoConsultaExalmar, HealthCheckExalmarResult } from './interfaces/exalmar.interface';
export declare class ExalmarService {
    private readonly exalmarDatabaseService;
    private readonly logger;
    private cache;
    private readonly CACHE_TTL;
    private readonly MAX_CONCURRENT_QUERIES;
    private readonly embarcacionesConfig;
    private readonly sistemaTablasMap;
    constructor(exalmarDatabaseService: ExalmarDatabaseService);
    private generateCacheKey;
    private getCachedData;
    private setCachedData;
    private executeWithLimitedConcurrency;
    consultarRegistros(dto: ConsultaGeneralExalmarDto): Promise<ResultadoConsultaExalmar>;
    private consultarEmbarcacionEspecifica;
    private consultarSistemaEspecifico;
    private consultarTodasLasEmbarcaciones;
    private traerRegistrosEmbarcacion;
    private agruparPorEmbarcacion;
    private agruparPorEmbarcacionConLimitePorTabla;
    private ordenarRegistrosPorReporteYFecha;
    healthCheck(): Promise<HealthCheckExalmarResult>;
    getEmbarcacionesDisponibles(): Promise<string[]>;
    getSistemasDisponibles(): Promise<string[]>;
    getBasesDatosDisponibles(): Promise<string[]>;
    private procesarRegistro;
    private procesarRegistroGenerico;
    private procesarReportesmelecto;
    private procesarSlave1;
    private procesarSlave3;
    private procesarAuxiliar;
    private procesarSlave5;
}
