import { ExalmarService } from './exalmar.service';
import { ConsultaGeneralExalmarDto } from './dto/consulta-exalmar.dto';
import { HealthCheckExalmarResult, ResultadoConsultaExalmar } from './interfaces/exalmar.interface';
export declare class ExalmarController {
    private readonly exalmarService;
    private readonly logger;
    constructor(exalmarService: ExalmarService);
    healthCheck(): Promise<HealthCheckExalmarResult>;
    getEmbarcacionesDisponibles(): Promise<string[]>;
    getSistemasDisponibles(): Promise<string[]>;
    getBasesDatosDisponibles(): Promise<string[]>;
    consultarRegistros(dto: ConsultaGeneralExalmarDto): Promise<ResultadoConsultaExalmar>;
    ruta1_ultimoRegistroGeneral(): Promise<ResultadoConsultaExalmar>;
    ruta3_ultimoRegistroSistema(sistema: string): Promise<ResultadoConsultaExalmar>;
    ruta4_registrosSistema(sistema: string, limit: string): Promise<ResultadoConsultaExalmar>;
    ruta5_ultimoRegistroEmbarcacion(embarcacion: string): Promise<ResultadoConsultaExalmar>;
    ruta6_registrosEmbarcacion(embarcacion: string, limit: string): Promise<ResultadoConsultaExalmar>;
    ruta7_consultaCompletaEmbarcacion(embarcacion: string, fechaInicio: string, fechaFin: string, sistema: string): Promise<ResultadoConsultaExalmar>;
    ruta8_consultaPorFechas(fechaInicio: string, fechaFin: string): Promise<ResultadoConsultaExalmar>;
    ruta9_consultaPorFechasSistema(fechaInicio: string, fechaFin: string, sistema: string): Promise<ResultadoConsultaExalmar>;
    ruta2_registrosGenerales(limit: string): Promise<ResultadoConsultaExalmar>;
    private isValidDate;
    private validateDateRange;
}
