import { OnModuleDestroy } from '@nestjs/common';
import { ConfigService } from '@nestjs/config';
import { Sequelize } from 'sequelize-typescript';
export interface ExalmarDatabaseConfig {
    host: string;
    port: number;
    username: string;
    password: string;
    database: string;
    dialect: 'mysql' | 'postgres' | 'sqlite' | 'mariadb' | 'mssql';
}
export interface ExalmarEmbarcacionDatabaseConfig {
    [embarcacionCode: string]: {
        [dbKey: string]: string;
    };
}
export declare class ExalmarDatabaseService implements OnModuleDestroy {
    private configService;
    private readonly logger;
    private connections;
    private readonly exalmarDatabases;
    constructor(configService: ConfigService);
    getActiveDatabases(embarcacionCode: string, tabla: string): Promise<string[]>;
    getConnection(embarcacionCode: string, dbKey: string): Promise<Sequelize>;
    getAllConnectionsForExalmar(): Promise<Map<string, Sequelize>>;
    private getDatabaseName;
    private getBaseConfig;
    getAvailableEmbarcaciones(): string[];
    getAvailableDatabases(): string[];
    onModuleDestroy(): Promise<void>;
    forceCloseAllConnections(): Promise<void>;
    getConnectionStats(): {
        company: string;
        totalConnectionsCreated: number;
        currentlyActiveConnections: number;
        activeConnections: {
            database: string;
            status: string;
        }[];
    };
    healthCheck(): Promise<{
        [key: string]: boolean;
    }>;
}
