import { HttpService } from '@nestjs/axios';
import { ConfigService } from '@nestjs/config';
import { AxiosResponse } from 'axios';
import { Observable } from 'rxjs';
export declare class ProxyService {
    private readonly httpService;
    private readonly configService;
    private readonly logger;
    private services;
    constructor(httpService: HttpService, configService: ConfigService);
    getTargetService(path: string): {
        url: string;
        serviceName: string;
        credentials?: any;
    } | null;
    proxyGet(targetUrl: string, path: string, headers: any, credentials?: any): Observable<AxiosResponse<any>>;
    proxyPost(targetUrl: string, path: string, body: any, headers: any, credentials?: any): Observable<AxiosResponse<any>>;
    proxyPut(targetUrl: string, path: string, body: any, headers: any, credentials?: any): Observable<AxiosResponse<any>>;
    proxyDelete(targetUrl: string, path: string, headers: any, credentials?: any): Observable<AxiosResponse<any>>;
    private sanitizeHeaders;
}
