"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var ProxyController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProxyController = void 0;
const common_1 = require("@nestjs/common");
const proxy_service_1 = require("./proxy.service");
const operators_1 = require("rxjs/operators");
const rxjs_1 = require("rxjs");
let ProxyController = ProxyController_1 = class ProxyController {
    proxyService;
    logger = new common_1.Logger(ProxyController_1.name);
    constructor(proxyService) {
        this.proxyService = proxyService;
    }
    async proxyRequest(req, res) {
        const { method, url, headers, body, query } = req;
        this.logger.log(`Incoming ${method} request to: ${url}`);
        let cleanPath = url;
        const credentialsPattern = /^\/user=([^&]+)&password=([^\/]+)(?=\/|$)/;
        const match = url.match(credentialsPattern);
        this.logger.log(`URL: ${url}`);
        this.logger.log(`Match result: ${JSON.stringify(match)}`);
        if (match) {
            cleanPath = url.replace(credentialsPattern, '');
            if (!cleanPath.startsWith('/')) {
                cleanPath = `/${cleanPath}`;
            }
            this.logger.log(`Cleaned path: ${cleanPath}`);
        }
        const target = this.proxyService.getTargetService(cleanPath);
        if (!target) {
            this.logger.error(`No service found for path: ${cleanPath} (original: ${url})`);
            throw new common_1.HttpException(`Service not found for path: ${url}`, common_1.HttpStatus.NOT_FOUND);
        }
        let clientUser;
        let clientPassword;
        if (target.serviceName !== 'auth') {
            if (match) {
                clientUser = match[1];
                clientPassword = match[2];
            }
            else {
                clientUser = query.user;
                clientPassword = query.password;
            }
            this.logger.log(`Client User: ${clientUser}`);
            this.logger.log(`Client Password: ${clientPassword}`);
            if (!clientUser || !clientPassword) {
                this.logger.error(`Missing client credentials in URL: ${url}`);
                throw new common_1.HttpException('Client credentials (user and password) are required in URL parameters', common_1.HttpStatus.UNAUTHORIZED);
            }
            const serviceName = target.serviceName.toUpperCase();
            const expectedUser = process.env[`${serviceName}_CLIENT_USER`];
            const expectedPassword = process.env[`${serviceName}_CLIENT_PASSWORD`];
            if (!expectedUser || !expectedPassword) {
                this.logger.error(`No client credentials configured for service: ${serviceName}`);
                throw new common_1.HttpException('Service authentication not configured', common_1.HttpStatus.INTERNAL_SERVER_ERROR);
            }
            if (clientUser !== expectedUser || clientPassword !== expectedPassword) {
                this.logger.error(`Invalid client credentials for service ${serviceName} in URL: ${url}`);
                throw new common_1.HttpException(`Invalid client credentials for ${serviceName.toLowerCase()} service`, common_1.HttpStatus.UNAUTHORIZED);
            }
        }
        else {
            this.logger.log(`Auth service detected - skipping client credentials validation`);
        }
        const cleanQuery = { ...query };
        delete cleanQuery.user;
        delete cleanQuery.password;
        const queryString = new URLSearchParams(cleanQuery).toString();
        const fullPath = queryString ? `${cleanPath}?${queryString}` : cleanPath;
        try {
            let proxyObservable;
            const forwardCredentials = target.serviceName === 'tasa' || target.serviceName === 'exalmar'
                ? { user: clientUser, password: clientPassword }
                : target.credentials;
            switch (method.toUpperCase()) {
                case 'GET':
                    proxyObservable = this.proxyService.proxyGet(target.url, fullPath, headers, forwardCredentials);
                    break;
                case 'POST':
                    proxyObservable = this.proxyService.proxyPost(target.url, fullPath, body, headers, forwardCredentials);
                    break;
                case 'PUT':
                    proxyObservable = this.proxyService.proxyPut(target.url, fullPath, body, headers, forwardCredentials);
                    break;
                case 'DELETE':
                    proxyObservable = this.proxyService.proxyDelete(target.url, fullPath, headers, forwardCredentials);
                    break;
                default:
                    throw new common_1.HttpException(`Method ${method} not supported`, common_1.HttpStatus.METHOD_NOT_ALLOWED);
            }
            const response = await (0, rxjs_1.firstValueFrom)(proxyObservable.pipe((0, operators_1.map)((response) => {
                this.logger.log(`Successfully proxied ${method} ${url} to ${target.serviceName} service`);
                return response;
            }), (0, operators_1.catchError)((error) => {
                this.logger.error(`Error proxying ${method} ${url} to ${target.serviceName}: ${error.message}`);
                return (0, rxjs_1.throwError)(() => error);
            })));
            Object.keys(response.headers).forEach((key) => {
                if (key.toLowerCase() !== 'content-encoding') {
                    res.setHeader(key, response.headers[key]);
                }
            });
            res.status(response.status).json(response.data);
        }
        catch (error) {
            this.logger.error(`Error processing request: ${error.message}`);
            const status = error.response?.status || common_1.HttpStatus.INTERNAL_SERVER_ERROR;
            const message = error.response?.data || error.message || 'Internal server error';
            res.status(status).json({
                statusCode: status,
                message,
                error: 'Proxy Error',
                service: target?.serviceName || 'Unknown',
            });
        }
    }
};
exports.ProxyController = ProxyController;
__decorate([
    (0, common_1.All)('*'),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ProxyController.prototype, "proxyRequest", null);
exports.ProxyController = ProxyController = ProxyController_1 = __decorate([
    (0, common_1.Controller)(),
    __metadata("design:paramtypes", [proxy_service_1.ProxyService])
], ProxyController);
//# sourceMappingURL=proxy.controller.js.map